/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.g9.support.ActionType;

/**
 * The checking state, invokes the check task, the hook and returns the
 * result
 * @param <V> type
 */
class Checking<V> extends ActionStage<V> implements Callable<Void> {

    /**
	 *
	 */

	/**
	 * @param g9Action action
	 */
	Checking(G9Action<V> g9Action) {
		super(g9Action);
	}

    /**
     * The checked hook. Invoked before the performed hook.
     *
     * @param checkResult the check result
     * @return the result from the checked hook
     * @exception Exception re-throws exception from hook method
     */
    Boolean checked(final Boolean checkResult) throws Exception {
        if (ga.shouldInvokeHook() && !ga.getCheckableHooks().isEmpty()) {
            String methodName = "checked";
            Class<?>[] params = {
                Boolean.class
            };
            ThreadType threadType = ga.getThreadType(methodName, params);
            HookMethod<Boolean> checkHook = new HookMethod<Boolean>(methodName) {
                @Override
                public Boolean call() throws Exception {
                    boolean result = checkResult;
                    for (Checkable hook : ga.getCheckableHooks()) {
                        result = hook.checked(result);
                    }
                    return result;
                }
            };
            return ga.getHookInvoker().execute(ga.getApplicationController(), threadType,
                    checkHook);
        }

        return checkResult;
    }

	@Override
    public Void call() throws Exception {
	    ActionType checkActionType = getCheckActionType();

	    ActionTask<Boolean> checkActionTask = JVineController
	    .getInstance(ga.getController()).getCheckDialogTask(
	            checkActionType, ga.getActionTarget());
	    checkActionTask.FLAG = ga.getFlag();
	    Boolean checkResult = checkActionTask.call();

	    if (checkResult == null) {
	        checkResult = Boolean.FALSE;
	        G9Action.getLog().info(ga + " check action failed. "
	                + "Using default value false");
	    }

	    if (!checked(checkResult).booleanValue()) {
	        ga.cancel();
	    }
	    G9Action.getLog().info(ga + " checked");
	    return null;

    }

    @SuppressWarnings("deprecation")
    private ActionType getCheckActionType() {
        switch (ga.getActionType()) {
            case FIND: // fall through

            case FINDALL: // fall through

            case INVOKE:
                return ActionType.CHECK_FIND;

            case INSERT:
            	return ActionType.INSERT;

            case UPDATE:
            	return ActionType.UPDATE;

            case SAVE:
                return ActionType.SAVE;

            case DELETE:
                return ActionType.CHECK_DELETE;

            case CLOSE:
                return ActionType.CHECK_CLOSE;
            case SELECT:
                return ActionType.SELECT;
            case UNSELECT:
                return ActionType.UNSELECT;
            case CLEAR:
                return ActionType.CHECK_CLEAR;
            case OPEN:
                return ActionType.OPEN;
            default:
                return null;
        }
    }

}