/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.Collection;
import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.controller.OSNode;
import no.esito.jvine.model.CurrentRoleObject;

/**
 * Class used to invoke the display action with the result of performing
 * this action.
 * @param <V> type
 */
class Display<V> extends ActionStage<V> implements Callable<Void> {

	/** The object to display */
    Object toDisplay;

    /**
     * Constructs a new display object.
     *
     * @param toDisplay the object to display
     * @param g9Action TODO
     */
    Display(G9Action<V> g9Action, Object toDisplay) {
    	super(g9Action);
		this.toDisplay = toDisplay;
    }

    /**
     * restoreCurrentInstances
     */
    void restoreCurrentInstances() {
        for (CurrentRoleObject cro : ga.getCurrentInstanceList()) {
            JVineController controller = JVineController
                    .getInstance(ga.getController());
            OSNode<?> node = controller.getOSNode(cro.getRole());
            Collection<?> allInstances = node.getAllInstances();
            for (Object object : allInstances) {
                if (object.equals(cro.getCurrent())) {
                    ga.getController().setCurrentInstance(cro.getRole(), object);
                    break;
                }
            }
        }
    }

    /**
     * The displayed hook. Invoked before the succeeded hook.
     *
     * @throws Exception re-throws exception from hook method.
     */
    void displayed() throws Exception {
        if (ga.shouldInvokeHook() && !ga.getDisplayableHooks().isEmpty()) {
            String methodName = "displayed";
            ThreadType threadType = ga.getThreadType(methodName, new Class[0]);
            HookMethod<Void> displayHook = new HookMethod<Void>(methodName) {
                @Override
                public Void call() throws Exception {
                    for (Displayable hook : ga.getDisplayableHooks()) {
                        hook.displayed();
                    }
                    return null;
                }
            };
            ga.getHookInvoker().execute(ga.getApplicationController(), threadType,
                    displayHook);
        }
    }

    @Override
    public Void call() throws Exception {
        JVineController jVineController = JVineController.getInstance(ga.getController());
        ActionTask<Void> displayActionTask = jVineController.getDisplayDialogTask(ga.getActionTarget(), ga.getActionType());
        displayActionTask.setTaskObject(toDisplay);
        displayActionTask.call();

        if (ga.isSaveAction()) {
            restoreCurrentInstances();
        }

        displayed();
        G9Action.getLog().info(ga + " displayed");

        return null;
    }

}