/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

/**
 * @version 1.0
 */
public interface Displayable {

    /**
     * The cleared hook. This hook is invoked after the action has been performed and
     * before the result is displayed.
     * <p>If applicable, this hook is invoked on a dedicated worker thread by
     * default. Use the annotation {@link ThreadInfo} to control which thread
     * this method is invoked on.
     */
    @ThreadInfo(ThreadType.WORKER)
    public void cleared();

    /**
     * The displayed hook. This hook is invoked after the action has been performed and
     * before the the dialog is claered.
     * <p>If applicable, this hook is invoked on a dedicated worker thread by
     * default. Use the annotation {@link ThreadInfo} to control which thread
     * this method is invoked on.
     */
    @ThreadInfo(ThreadType.WORKER)
	public void displayed();

}