/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;

/**
 * The finishing state, invokes the finished hook
 * @param <V> type
 */
class Finishing<V> extends ActionStage<V> implements Callable<Void> {

	/**
	 * @param g9Action action
	 */
	Finishing(G9Action<V> g9Action) {
	    super(g9Action);
	}

    /**
     * This finished hook, unconditionally invoked as the last method in an
     * action life cycle. This hook is invoked on a dedicated worker thread by
     * default. Use the annotation {@link ThreadInfo} to control which thread
     * this method is invoked on.
     *
     * @return Void - e.g. null
     * @exception Exception re-throws exception from hook method
     */
    Void finished() throws Exception {
        if (ga.shouldInvokeHook()) {
            String methodName = "finished";
            ThreadType threadType = ga.getThreadType(methodName, new Class[0]);
            HookMethod<Void> invocation = new HookMethod<Void>(methodName) {

                @Override
                public Void call() {
                    for (ActionHook<?> hook : ga.getActionHookList().getHooks()) {
                        hook.finished();
                    }
                    return null;
                }
            };
            ga.getHookInvoker().execute(ga.getApplicationController(), threadType, invocation);
        }
        return null;
    }

	@Override
    public Void call() throws Exception {
        finished();
        G9Action.getLog().info(ga + " finished");
        return null;
    }
}