/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import no.esito.jvine.action.HookMethod;
import no.esito.util.BeanID;
import no.g9.client.core.controller.ApplicationController;

/**
 * The invoke method is used to invoke a hook method on the correct thread type
 * (either gui or worker). The actual implementation depends on the target of
 * the application.
 */
@BeanID("hookInvoker")
public interface HookInvoker {

    /**
     * Invokes the specified hook method on the specified thread type.
     * 
     * @param <V> The return type of the hook method
     * @param appCtrl The application controller
     * @param threadType The enum defining the kind of thread to invoke the hook
     *            on.
     * @param hookMethod The callable hook method
     * @return The result of invoking the hook
     * @exception Exception if invoking the hook method resulted in an
     *                exception, it is re-thrown.
     */
    public <V> V execute(ApplicationController appCtrl, ThreadType threadType,
            HookMethod<V> hookMethod) throws Exception;

}