/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.g9.support.ClientContext;
import no.g9.support.ObjectSelection;

/**
 * The obtaining state - performs the obtain action and invokes the hook
 * @param <V> type
 */
class Obtaining<V> extends ActionStage<V> implements Callable<Object[]> {
    /**
	 *
	 */

	/**
	 * @param g9Action the action
	 */
	Obtaining(G9Action<V> g9Action) {
		super(g9Action);
	}

    /**
     * Invoke the client context hook
     *
     * @param clientContext the current client context
     * @return the client context to use
     * @throws Exception all exceptions are re-thrown.
     */
	@SuppressWarnings("rawtypes")
    ClientContext contextHook(final ClientContext clientContext)
            throws Exception {
        if (ga.shouldInvokeHook() && !ga.getObtainableHooks().isEmpty()) {
            String methodName = "contextHook";
			Class[] params = {
                ClientContext.class
            };
            ThreadType threadType = ga.getThreadType(methodName, params);
            HookMethod<ClientContext> contextHook = new HookMethod<ClientContext>(
                    methodName) {
                @Override
                public ClientContext call() throws Exception {
                    ClientContext ctx = clientContext;
                    for (Obtainable hook : ga.getObtainableHooks()) {
                        ctx = hook.contextHook(ctx);
                    }
                    return ctx;
                }
            };

            return ga.getHookInvoker().execute(ga.getApplicationController(), threadType,
                    contextHook);
        }

        return clientContext;
    }

    /**
     * The obtained hook. Invoked before the performed hook.
     * @param objectSelection the object selection
     *
     * @return the object selection
     * @throws Exception re-throws exception from hook method.
     */
    @SuppressWarnings("rawtypes")
    ObjectSelection obtained(final ObjectSelection objectSelection)
            throws Exception {
        if (ga.shouldInvokeHook() && !ga.getObtainableHooks().isEmpty()) {
            String methodName = "obtained";
            Class[] params = {
                ObjectSelection.class
            };
            ThreadType threadType = ga.getThreadType(methodName, params);
            HookMethod<ObjectSelection> obtainHook = new HookMethod<ObjectSelection>(
                    methodName) {
                @Override
                public ObjectSelection call() throws Exception {
                    ObjectSelection os = objectSelection;
                    for (Obtainable hook : ga.getObtainableHooks()) {
                        os = hook.obtained(os);
                    }
                    return os;
                }
            };
            return ga.getHookInvoker().execute(ga.getApplicationController(), threadType,
                    obtainHook);

        }

        return objectSelection;

    }

	@Override
    public Object[] call() throws Exception {
        ObjectSelection objectSelection = null;
        ClientContext clientContext = null;

        JVineController jVineController = JVineController
        .getInstance(ga.getController());

        ActionTask<ObjectSelection> obtainActionTask = jVineController.getObtainDialogTask(ga.getActionTarget(), ga.getActionType());
        objectSelection = obtainActionTask.call();

        objectSelection = obtained(objectSelection);

        clientContext = ga.getController().getApplicationController()
        .getClientContext();
        clientContext = contextHook(clientContext);

        G9Action.getLog().info(ga + " obtained");

        Object[] returnValue = {
                objectSelection, clientContext
        };
        return returnValue;
    }

}