/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;
import no.esito.jvine.controller.JVineController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;

/** The succeeded state, invokes the succeeded hook.
 * @param <V> type */
public class Succeeding<V> extends ActionStage<V> implements Callable<Void> {

	/**
	 * @param g9Action action
	 */
	Succeeding(G9Action<V> g9Action) {
	    super(g9Action);
	}

    /**
     * The succeeded hook, invoked after performed(Object) unless the
     * action failed or the action was cancelled. This hook is invoked on a dedicated
     * worker thread by default. Use the annotation {@link ThreadInfo} to control
     * which thread this method is invoked on.
     *
     * @return Void - e.g. null
     * @exception Exception re-throws exception from hook method
     */
    Void succeeded() throws Exception {
        if (G9Action.getLog().isDebugEnabled()) {
            G9Action.getLog().debug(this + " succeeded.");
        }
        if (ga.shouldInvokeHook()) {
            String methodName = "succeeded";
            ThreadType threadType = ga.getThreadType(methodName, new Class[0]);
            HookMethod<Void> invocation = new HookMethod<Void>(methodName) {

                @Override
                public Void call() {
                    for (ActionHook<?> hook : ga.getActionHookList().getHooks()) {
                        hook.succeeded();
                    }
                    return null;
                }
            };
            ga.getHookInvoker().execute(ga.getApplicationController(), threadType, invocation);
        }
        return null;
    }

	@Override
    public Void call() throws Exception {
	    DialogConstant applicationDialogConstant = ga.getApplicationController().getApplicationDialogConstant();
		DialogController dc = ga.getApplicationController().getDialogController(applicationDialogConstant);
	    ga.getMessageUtil().clearContextMessages(JVineController.getInstance(dc));
	    succeeded();
	    G9Action.getLog().info(ga + " succeeded");
	    return null;
    }
}