/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

/**
 * Enumerates the type of thread a hook method can be invoked on.
 *
 */
public enum ThreadType {

    /**
     * A gui thread type. Threads of this type will block the gui, and is not
     * intended for long-lasting work (shuch as looking up values from a data
     * base, etc.) This is only applicable in environments where the gui-thread
     * is controlled, e.g. a swing application
     */
    GUI,

    /**
     * The worker thread type, intended for non-gui related work, e.g. looking
     * up values in a data base etc. It is not safe to maniupulate the gui in
     * any way on this kind of thread.
     */
    WORKER;
}
