/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;


/**
 * CallBackProvider declares the method <code>getCallBack()</code> which
 * is useful when defining a DialogSetupValue.
 * <p>
 * Typical usage in a DialogController's setup method:
 * <pre>
 * public void setup(DialogSetupValue&lt;?&gt; setupValue) {
 *      if (setupValue instanceof CallBackProvder) {
 *          CallBackProvider cbProvider = (CallBackaProvider) setupValue;
 *          setCallBack(cbProvider.getCallBack());
 *      }
 *      ....
 * }
 * </pre>
 *
 */
public interface CallBackProvider {

    /**
     * Get the call back
     * @return the call back
     */
    CallBack getCallBack();
}
