/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

import no.g9.os.RoleConstant;

/**
 * Controls the the iteration of an object selection tree.
 */
public abstract class Interceptor {

    /**
     * The directives govern how <em>check change</em> iterates the node (sub)
     * structure and the result of the iteration.
     */
    public static enum DIRECTIVE {
        /**
         * The node is considered changed. This value stops the iteration.
         */
        CHANGED,

        /**
         * The default value, check this node and if the node is unchanged,
         * continue to check child nodes.
         */
        DEFAULT,

        /**
         * Consider this node unchanged and continue to check child nodes.
         */
        CONTINUE,

        /**
         * Neither this node nor any of it's child nodes are changed. This value
         * stops the iteration.
         */
        UNCHANGED;
    }

    private final RoleConstant role;

    /**
     * Constructs a new Interceptor.
     * 
     * @param role the object selection role this interceptor is hooked on to.
     */
    public Interceptor(RoleConstant role) {
        this.role = role;
    }

    /**
     * Returns the constant identifying the role this interceptor is hooked on
     * to.
     * 
     * @return the interceptor's role.
     */
    public final RoleConstant getRole() {
        return role;
    }

    /**
     * Invoked when the ongoing task is about to be performed on the node this
     * interceptor is hooked on to.
     * 
     * @param actionTarget the target of the ongoing action.
     * @return the directive governing how the ongoing task will proceed.
     */
    public abstract DIRECTIVE intercept(RoleConstant actionTarget);
}
