/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.converter;

import java.util.Collection;
import java.util.Map;

import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.exception.G9BaseException;
import no.g9.message.CRuntimeMsg;
import no.g9.message.MessageSystem;

/**
 * Exception thrown to indicate that one or more framework converters has failed
 * to convert a value to the view model. The exception keeps a map of the failed
 * fields and the conversion message.
 */
public class FrameworkConversionException extends G9BaseException {

    private final Map<DialogObjectConstant, Collection<?>> messages;

    /**
     * Construct a new framework conversion exception.
     * @param messages map of fields that failed conversion
     */
    public FrameworkConversionException(
            Map<DialogObjectConstant, Collection<?>> messages) {
        this.messages = messages;
        setErrMsg(MessageSystem.getMessageFactory().getMessage(
                CRuntimeMsg.CF_FRAMEWORK_CONVERSION_FAILED));
    }

    /**
     * Get the map of field that failed conversion and the corresponding message
     * @return fields that failed conversion
     */
    public Map<DialogObjectConstant, Collection<?>> getMessages() {
        return messages;
    }

}
