/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.util;

import java.util.MissingResourceException;

import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.view.DialogView;

/**
 * Utility class. Used to get the label text for a dialog object.
 */
public class MessageTextHelper {

    /**
     * Get the label text or title for the field. If the field has an attached
     * label, the label's title is returned. Otherwise, the field's title is
     * returned.
     *
     * @param validatorContext context containing field, dialog controller etc.
     * @return the field's label title or the field's title.
     */
    public static Object getLabelTextForField(ValidateContext validatorContext) {
        DialogObjectConstant attribute = validatorContext.getField();
        return getLabelTextForField(validatorContext.getDialogController().getDialogView(), attribute);
    }

    /**
     * @param dialog dialog
     * @param attribute attribute
     * @return label text
     */
    public static Object getLabelTextForField(DialogView dialog, DialogObjectConstant attribute) {
        DialogObjectConstant label = attribute.getLabelComponent();
        Object msgArg = null;
        if (label != null) {
            try {
                msgArg = dialog.getTitle(label);
            } catch (MissingResourceException e) {
                msgArg = label;
            }
        } else {
            try {
                msgArg = dialog.getTitle(attribute);
            } catch (MissingResourceException re) {
                msgArg = attribute;
            }
        }
        return msgArg;
    }
}
