/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.validator;

/**
 * Common interface for attribute validators
 */
public interface FieldValidator {
    /**
     * Validates a candidate value.
     * Note: The input value may very well be null. Null should in most (all)
     * cases be treated as a valid value.
     * @param value The candidate value to validate
     * @param context Validation context
     * @return Result of the validation
     */
    public ValidationResult validate(Object value, ValidateContext context);



}
