/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.validator;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * ValidationPolicy is used to annotate {@link FieldValidator} with a validation
 * policy. Two types of policies can be used:
 * <dl>
 * <dt>Policy.ON_SAVE</dt>
 * <dd>Validation is performed as part of a <em>save</em> action.</dd>
 * <dt>Policy.ON_CHANGE</dt>
 * <dd>Validation is performed when the end user changes the field value. 
 * </dl>
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
public @interface ValidationPolicy {

    /**
     * Get the trigger value of this validator type.
     * 
     * @return trigger value
     */
    Policy value();

    /**
     * Enumerates the policies that can be applied on a validator.
     */
    public enum Policy {

        /**
         * An <em>on save</em> validator is invoked as part of an actions
         * check-save phase.
         */
        ON_SAVE,

        /**
         * An <em>on change</em> validator is invoked when the
         * field's value is read from the view model.
         */
        ON_CHANGE;
    }
}
