/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

import java.io.Serializable;

/**
 * This class has model info for an image.
 */
public class ImageInfo implements Serializable {

	private final String name;

	private final String fileName;

	private final int width;

	private final int height;

	/**
	 * Create a new ImageInfo with properties from the model.
	 *
	 * @param name name
	 * @param fileName file name
	 * @param width width
	 * @param height height
	 */
	public ImageInfo(String name, String fileName, int width, int height) {
		super();
		this.name = name;
		this.fileName = fileName;
		this.width = width;
		this.height = height;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the fileName
	 */
	public String getFileName() {
		return fileName;
	}
	
	/**
	 * @return the width
	 */
	public int getWidth() {
		return width;
	}

	/**
	 * @return the height
	 */
	public int getHeight() {
		return height;
	}

}
