/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

import no.esito.jvine.view.ViewModelImpl;
import no.g9.client.core.message.InteractionThreadPolicy;
import no.g9.client.core.message.MessageCallback;
import no.g9.message.Message;
import no.g9.message.MessageReplyType;
import no.g9.os.RoleConstant;

/**
 * A message callback class for handling list selections.
 */
public class ListSelectionCallback implements MessageCallback {

	private ViewModelImpl viewModel;
    private boolean selected;
    private RoleConstant role;
    private int rowNo;
    private ListRow emptyRow;
    private boolean canceled = false;

	/**
     * Create a new list selection callback object, will be triggered from the
     * framework after the user has made a reply to the message box.
     *
     * @param viewModel - the view model which holds the list
     * @param selected - the selected state for the list row
     * @param role - the object selection role for the list
     * @param rowNo - the row in question
     * @param emptyRow - an empty row for the list, contains a collection of all
     *                   fields in the list row
     */
	public ListSelectionCallback(ViewModelImpl viewModel, boolean selected,
            RoleConstant role, int rowNo, ListRow emptyRow) {
        this.viewModel = viewModel;
        this.selected = selected;
        this.role = role;
        this.rowNo = rowNo;
        this.emptyRow = emptyRow;
    }

	/*
     * (non-Javadoc)
     * @see no.g9.message.MessageCallback#reply(no.g9.message.Message)
     */
    @Override
    public void reply(Message msg) {
        if (msg.getReply() == MessageReplyType.REPLY_OK) {
            viewModel.setListRowSelection(selected, role, rowNo, emptyRow);
        } else {
            viewModel.resetListRowSelection(role);
            canceled = true;
        }
    }

    /**
     * @return true if the selection was canceled by the user.
     */
    public boolean isCanceled() {
        return canceled;
    }

    @Override
    public InteractionThreadPolicy getInteractionThreadPolicy() {
        return InteractionThreadPolicy.ASYNC_GUI_POLICY;
    }



}
