/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.menu;


/**
 * A menu separator from the dialog model.
 */
public class Separator extends MenuBase {

    /**
     * Create a new separator.
     *
     * @param id the ID of the separator
     * @param dialogId the ID of the dialog which owns the separator
     * @param style the style from the dialog model
     */
    public Separator(String id, String dialogId, String style) {
        super(id, dialogId, null, null, null, style, null, null);
    }

    @Override
    public String toString() {
        return "Separator [id=" + getId() + "/" + getDialogId() + "]";
    }

}
