/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.spreadsheet;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * The default workbook provider will create new POI workbooks
 * in one of the supported workbook formats.
 */
public class DefaultWorkbookProvider implements WorkbookProvider {

	@Override
	public Workbook createWorkbook(WORKBOOK_FORMAT bookFormat) {
		if (bookFormat.equals(WORKBOOK_FORMAT.XLSX)) {
			return new XSSFWorkbook();
		}
		else if (bookFormat.equals(WORKBOOK_FORMAT.XLS)) {
			return new HSSFWorkbook();
		}
		throw new IllegalArgumentException("Unknown workbook format: " + bookFormat);
	}

}
