/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.action;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import no.esito.jvine.action.ActionQueue;
import no.esito.log.Logger;

public final class BlockingGuiActionQueue
implements ActionQueue {
    private static final Logger log = Logger.getLogger(BlockingGuiActionQueue.class);
    private SynchronousQueue<TaskWrap<?>> taskQueue = new SynchronousQueue();
    private final TaskWrap<Void> POISON = new TaskWrap<Void>(new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            return null;
        }
    });

    @Override
    public final <V> V perform(Callable<V> task) throws InvocationTargetException {
        log.debug((Object)("Adding task to queue " + task));
        TaskWrap<V> taskWrap = new TaskWrap<V>(task);
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.taskQueue.put(taskWrap);
                }
                catch (InterruptedException e1) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            while (true) {
                V e1;
                try {
                    e1 = taskWrap.getResultValue();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                return e1;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public final void perform(final Runnable task) throws InvocationTargetException {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                task.run();
                return null;
            }

            public String toString() {
                return task.toString();
            }
        };
        this.perform(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ready() {
        log.debug((Object)"Ready to perform tasks.");
        boolean interrupted = false;
        try {
            while (true) {
                TaskWrap<?> taskWrap = null;
                try {
                    taskWrap = this.taskQueue.take();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                if (this.POISON == taskWrap) {
                    log.trace((Object)"Got poison pill");
                    break;
                }
                if (taskWrap == null) continue;
                log.debug((Object)("Performing gui task: " + taskWrap));
                taskWrap.performTask();
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        log.debug((Object)"Finished perfoming tasks.");
    }

    @Override
    public final void release() {
        boolean interrupted = false;
        log.trace((Object)"About to post poison pill.");
        try {
            while (true) {
                try {
                    this.taskQueue.put(this.POISON);
                }
                catch (InterruptedException e) {
                    log.trace((Object)"Interrupted!");
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            log.trace((Object)"Posted poison pill.");
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class TaskWrap<V> {
        private Callable<V> task;
        private V resultValue;
        private CountDownLatch gate = new CountDownLatch(1);
        private volatile Exception caughtException = null;

        TaskWrap(Callable<V> task) {
            this.task = task;
        }

        final void performTask() {
            log.debug((Object)("Performing task " + this.task));
            try {
                this.resultValue = this.task.call();
            }
            catch (Exception e) {
                log.warn((Object)"Caught exception during action execution", (Throwable)e);
                this.caughtException = e;
            }
            finally {
                this.gate.countDown();
            }
        }

        final V getResultValue() throws InterruptedException, InvocationTargetException {
            this.gate.await();
            if (this.caughtException != null) {
                throw new InvocationTargetException(this.caughtException);
            }
            return this.resultValue;
        }

        public String toString() {
            return this.task.toString();
        }
    }
}

