/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import no.esito.jvine.validation.ValidationMessageHelper;
import no.esito.jvine.view.ViewModelImpl;
import no.esito.util.BeanID;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.controller.DialogObjectType;
import no.g9.client.core.controller.RoleState;
import no.g9.client.core.validator.FieldValidator;
import no.g9.client.core.validator.MandatoryValidator;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationPolicy;
import no.g9.client.core.validator.ValidationResult;
import no.g9.os.AttributeConstant;
import no.g9.os.OSRole;
import no.g9.os.RoleConstant;
import no.g9.service.G9Spring;
import no.g9.support.ActionType;

@BeanID(value="validationManager")
public final class ValidationManager {
    private ValidationPolicy.Policy defaultPolicy = ValidationPolicy.Policy.ON_SAVE;
    private ActionType actionType;
    private DialogController dctrl;

    private ValidationManager() {
    }

    public void setDefaultPolicy(ValidationPolicy.Policy defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    public ValidationPolicy.Policy getDefaultPolicy() {
        return this.defaultPolicy;
    }

    ValidationManager initManager(ActionType actionType, DialogController dctrl) {
        ValidationManager manager = new ValidationManager();
        manager.defaultPolicy = this.defaultPolicy;
        manager.actionType = actionType;
        manager.dctrl = dctrl;
        return manager;
    }

    public Map<ValidationResult, ValidateContext> validate(AttributeConstant attribute, RoleConstant actionTarget, ValidationPolicy.Policy policy) {
        LinkedHashMap<ValidationResult, ValidateContext> resultMap = new LinkedHashMap<ValidationResult, ValidateContext>();
        Collection<DialogObjectConstant> attributeFields = this.dctrl.getViewModel().getAttributeFields(attribute);
        if (attributeFields != null) {
            DialogObjectConstant diaconst;
            DialogObjectConstant parent;
            DialogObjectConstant field = null;
            ValidateContext context = null;
            Iterator<DialogObjectConstant> iterator = attributeFields.iterator();
            while (iterator.hasNext() && ((parent = (DialogObjectConstant)(diaconst = (context = new ValidateContext(this.dctrl, field = iterator.next(), this.actionType)).getDialogObjectConstant()).getParent()) == null || parent.getType() == DialogObjectType.TableBlock)) {
            }
            List<FieldValidator> validators = this.getValidator(attribute, policy);
            if (validators != null && !validators.isEmpty()) {
                for (FieldValidator val : validators) {
                    if (!this.doValidate(field, actionTarget)) continue;
                    Object value = this.getValue(field);
                    ValidationResult valResult = val.validate(value, context);
                    resultMap.put(valResult, context);
                }
            }
        }
        return this.passResultToController(policy, resultMap);
    }

    boolean doValidate(DialogObjectConstant field, RoleConstant actionTarget) {
        RoleState state = this.dctrl.getState(field.getAttribute().getAttributeRole());
        if (state == RoleState.CLEAN || state == RoleState.CLEARED) {
            RoleState parentState;
            if (field.getAttribute().getAttributeRole() == actionTarget) {
                return true;
            }
            Object osRole = this.dctrl.getOSRole(field.getAttribute().getAttributeRole());
            if (osRole.isUpRelated() && osRole.getParent() != null && (parentState = this.dctrl.getState(osRole.getParent().getRoleConstant())) != RoleState.CLEARED) {
                return true;
            }
            List children = this.dctrl.getOSRole(field.getAttribute().getAttributeRole()).getChildren();
            return this.hasDirtyChildren(children) && this.isChildOfTarget((OSRole<?>)osRole, actionTarget);
        }
        return true;
    }

    private boolean isChildOfTarget(OSRole<?> osRole, RoleConstant actionTarget) {
        if (osRole.getParent() == null) {
            return false;
        }
        if (osRole.getParent().getRoleConstant() == actionTarget) {
            return true;
        }
        return this.isChildOfTarget(osRole.getParent(), actionTarget);
    }

    private boolean hasDirtyChildren(List<OSRole<?>> children) {
        if (children == null || children.size() == 0) {
            return false;
        }
        for (OSRole<?> child : children) {
            RoleState state = this.dctrl.getState(child.getRoleConstant());
            if (state != RoleState.CLEARED) {
                return true;
            }
            if (!this.hasDirtyChildren(child.getChildren())) continue;
            return true;
        }
        return false;
    }

    private Map<ValidationResult, ValidateContext> passResultToController(ValidationPolicy.Policy policy, Map<ValidationResult, ValidateContext> resultMap) {
        if (policy == ValidationPolicy.Policy.ON_CHANGE && !(resultMap = ValidationMessageHelper.getFailed(resultMap)).isEmpty()) {
            resultMap = this.dctrl.failedOnChangeValidator(resultMap);
        }
        return resultMap;
    }

    public Map<ValidationResult, ValidateContext> validate(DialogObjectConstant field, Object value, ValidationPolicy.Policy policy, ValidateContext context) {
        HashMap<ValidationResult, ValidateContext> validationResults = new HashMap<ValidationResult, ValidateContext>();
        List<FieldValidator> validator = this.getValidator(field.getAttribute(), policy);
        for (FieldValidator fieldValidator : validator) {
            validationResults.put(fieldValidator.validate(value, context), context);
        }
        return this.passResultToController(policy, validationResults);
    }

    private Object getValue(DialogObjectConstant field) {
        Object dialogView = this.dctrl.getDialogView();
        ViewModelImpl viewModel = (ViewModelImpl)dialogView.getViewModel();
        return viewModel.getField(field);
    }

    private FieldValidator getMandatoryValidator(AttributeConstant attribute) {
        Object dialogView = this.dctrl.getDialogView();
        Collection<DialogObjectConstant> attributeFields = dialogView.getViewModel().getAttributeFields(attribute);
        for (DialogObjectConstant dialogObjectConstant : attributeFields) {
            if (!dialogView.isMandatory(dialogObjectConstant)) continue;
            return new MandatoryValidator();
        }
        return null;
    }

    private List<FieldValidator> getValidator(AttributeConstant attribute, ValidationPolicy.Policy policy) {
        String validatorID;
        ArrayList<FieldValidator> validators = new ArrayList<FieldValidator>();
        FieldValidator mandatoryValidator = this.getMandatoryValidator(attribute);
        if (this.confirmPolicy(mandatoryValidator, policy)) {
            validators.add(mandatoryValidator);
        }
        FieldValidator validator = null;
        if (attribute != null && (validatorID = attribute.getValidatorId()) != null && this.confirmPolicy(validator = (FieldValidator)G9Spring.getBean((String)validatorID), policy)) {
            validators.add(validator);
        }
        return validators;
    }

    public boolean confirmPolicy(FieldValidator validator, ValidationPolicy.Policy policy) {
        if (validator == null) {
            return false;
        }
        if (policy == null || policy == ValidationPolicy.Policy.ON_SAVE) {
            return true;
        }
        return this.getValidatorType(validator) == policy;
    }

    private ValidationPolicy.Policy getValidatorType(FieldValidator validator) {
        ValidationPolicy annotation;
        ValidationPolicy.Policy type = this.getDefaultPolicy();
        if (validator != null && (annotation = validator.getClass().getAnnotation(ValidationPolicy.class)) != null) {
            type = annotation.value();
        }
        return type;
    }
}

