/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.view;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.esito.jvine.action.GuiTask;
import no.esito.jvine.action.ThreadManager;
import no.esito.jvine.action.UAMessageCallback;
import no.esito.jvine.communication.SystemMessagePipe;
import no.esito.jvine.controller.DialogInstanceKeyFromExternal;
import no.esito.jvine.controller.JVineAppController;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.view.AbstractDialogView;
import no.esito.jvine.view.ViewModelImpl;
import no.esito.log.Logger;
import no.esito.util.ServiceLoader;
import no.g9.client.core.action.CheckType;
import no.g9.client.core.communication.SystemMessage;
import no.g9.client.core.controller.ApplicationController;
import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.message.BlockingMessageCallback;
import no.g9.client.core.message.InteractionThreadPolicy;
import no.g9.client.core.message.JVineDispatcherContext;
import no.g9.client.core.message.MessageCallback;
import no.g9.client.core.view.ApplicationView;
import no.g9.client.core.view.DialogView;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.WindowEvent;
import no.g9.message.DispatcherContext;
import no.g9.message.Message;
import no.g9.message.MessageDispatcher;
import no.g9.message.MessageReplyType;
import no.g9.message.MessageSystem;
import no.g9.os.RoleConstant;
import no.g9.os.UsertypeRoleConstant;
import no.g9.service.G9Spring;
import no.g9.support.ActionType;

public abstract class AbstractApplicationView
implements ApplicationView,
SystemMessagePipe {
    private static final String VIEW = "View";
    protected static final Logger log = Logger.getLogger(DialogView.class);
    private ApplicationController applicationController;
    private final Map<DialogInstance, ViewModel> viewModels = new HashMap<DialogInstance, ViewModel>();
    private final Map<DialogInstance, AbstractDialogView> dialogViews = new HashMap<DialogInstance, AbstractDialogView>();
    private final List<DialogInstance> openDialogs = new ArrayList<DialogInstance>();
    private final List<DialogInstance> openDialogBoxes = new ArrayList<DialogInstance>();
    private final Map<DialogInstance, Boolean> shown = new HashMap<DialogInstance, Boolean>();
    private final Map<DialogInstance, String> dialogTitle = new HashMap<DialogInstance, String>();
    private Message message;
    private MessageCallback messageCallback;
    private final List<SystemMessage> outputMessages = new ArrayList<SystemMessage>();

    public AbstractApplicationView(ApplicationController applicationController) {
        this.setApplicationController(applicationController);
        applicationController.setApplicationView(this);
    }

    @Override
    public ApplicationController getApplicationController() {
        return this.applicationController;
    }

    protected void setApplicationController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public final synchronized ViewModel getViewModel(DialogConstant dialog) {
        return this.getViewModel(this.getCurrentDialogInstance(dialog));
    }

    public final synchronized ViewModel getViewModel(DialogInstance dialog) {
        ViewModel viewModel = this.viewModels.get(dialog);
        if (viewModel == null) {
            viewModel = new ViewModelImpl(dialog, this);
            this.viewModels.put(dialog, viewModel);
        }
        return viewModel;
    }

    @Override
    public final synchronized <T extends DialogView> T getDialogView(DialogConstant dialog) {
        DialogInstance instance = this.getCurrentDialogInstance(dialog);
        return this.getDialogView(instance);
    }

    public final synchronized <T extends DialogView> T getDialogView(DialogInstance instance) {
        if (this.isNullOrEmptyInstance(instance)) {
            return null;
        }
        AbstractDialogView dialogView = this.dialogViews.get(instance);
        if (dialogView == null) {
            dialogView = this.createDialogViewInternal(instance);
        }
        return (T)dialogView;
    }

    private boolean isNullOrEmptyInstance(DialogInstance instance) {
        if (instance == null) {
            return true;
        }
        String dialogName = this.getDialogName(instance.getDialogConstant());
        return dialogName.equals(this.getEmptyDialogName());
    }

    public final synchronized boolean hasOpenDialogView(DialogInstance instance) {
        if (this.isNullOrEmptyInstance(instance)) {
            return false;
        }
        return this.dialogViews.containsKey(instance);
    }

    public synchronized <T extends AbstractDialogView> T createDialogView(DialogInstance instance) {
        String dialogName = this.getDialogName(instance.getDialogConstant());
        if (dialogName.equals(this.getEmptyDialogName())) {
            return null;
        }
        AbstractDialogView dialogView = this.dialogViews.get(instance);
        if (dialogView == null) {
            dialogView = this.createDialogViewInternal(instance);
        }
        return (T)dialogView;
    }

    private synchronized AbstractDialogView createDialogViewInternal(DialogInstance instance) {
        Object dialogView = this.loadDialogView(instance.getDialogConstant().getInternalName(), instance.getDialogInstanceNumber());
        this.dialogViews.put(instance, (AbstractDialogView)dialogView);
        ((AbstractDialogView)dialogView).setApplicationView(this);
        if (this.getDialogController(instance) == null) {
            this.getApplicationController().createDialogInstance(instance.getDialogConstant(), instance.getDialogInstanceNumber());
        }
        JVineController.getInstance(this.getDialogController(instance)).registerView((DialogView)dialogView);
        return dialogView;
    }

    private synchronized <T extends AbstractDialogView> T loadDialogView(String beanID, int instanceNumber) {
        beanID = beanID + VIEW;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new view using beanID " + beanID + " (instance " + instanceNumber + ")"));
        }
        AbstractDialogView dialogView = (AbstractDialogView)G9Spring.getBean(DialogView.class, (String)beanID);
        dialogView.setDialogInstanceNumber(instanceNumber);
        return (T)dialogView;
    }

    synchronized void addDialogView(AbstractDialogView view) {
        this.dialogViews.put(view.getDialogInstance(), view);
    }

    public DialogController getDialogController(DialogConstant dialogConstant) {
        return this.getApplicationController().getDialogController(dialogConstant);
    }

    public DialogController getDialogController(DialogInstance dialogInstance) {
        return this.getApplicationController().getDialogController(dialogInstance);
    }

    public String getCurrentDialogInstanceName(boolean doOpenFirst) {
        DialogInstance instance = this.getCurrentDialog(doOpenFirst);
        return this.getDialogInstanceName(instance);
    }

    public DialogInstance getCurrentDialog(boolean doOpenFirst) {
        if (this.openDialogs.isEmpty()) {
            DialogInstance firstDialog = this.getFirstDialogInstance();
            if (firstDialog != null && doOpenFirst) {
                this.openDialogs.add(firstDialog);
                this.triggerDialogEvent(firstDialog, WindowEvent.OPENED);
            } else {
                return firstDialog;
            }
        }
        return this.openDialogs.get(this.openDialogs.size() - 1);
    }

    protected abstract DialogConstant getFirstDialog();

    public abstract String getEmptyDialogName();

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public MessageCallback getMessageCallback() {
        return this.messageCallback;
    }

    public void setMessageCallback(MessageCallback messageCallback) {
        this.messageCallback = messageCallback;
    }

    public boolean getShowMessage() {
        return this.message != null;
    }

    public void handleMessageReply(MessageReplyType reply) {
        Message currentMsg = this.message;
        MessageCallback currentCb = this.messageCallback;
        this.message = null;
        this.messageCallback = null;
        currentMsg.setReply(reply);
        if (currentCb != null) {
            currentCb.reply(currentMsg);
        }
    }

    @Override
    public void performAction(ActionType action, DialogConstant target) {
        this.performAction(action, target, false);
    }

    @Override
    public void performAction(ActionType action, DialogConstant target, Boolean flag) {
        this.performAction(action, target, flag, false);
    }

    public void performAction(ActionType action, DialogConstant target, Boolean flag, boolean fromExternal) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("performAction: " + action + " " + target + ", flag: " + flag));
        }
        switch (action) {
            case OPEN: {
                this.open(target, flag, fromExternal);
                break;
            }
            case CLOSE: {
                this.close(target);
                break;
            }
            case SHOW: {
                this.show(target);
                break;
            }
            case HIDE: {
                this.hide(target);
                break;
            }
            case CLEAROBJECT: {
                this.clearObject(target);
                break;
            }
            default: {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)("Application action not handled: " + action));
            }
        }
    }

    public String getDialogName(DialogConstant dialogConstant) {
        return dialogConstant.getG9Name();
    }

    public String getDialogInstanceName(DialogInstance instance) {
        if (instance == null) {
            return this.getEmptyDialogName();
        }
        String retVal = this.getDialogName(instance.getDialogConstant());
        if (instance.getDialogInstanceNumber() > 1) {
            retVal = retVal + instance.getDialogInstanceNumber();
        }
        return retVal;
    }

    private void triggerDialogEvent(DialogInstance dialogInstance, WindowEvent type) {
        AbstractDialogView view = (AbstractDialogView)this.getDialogView(dialogInstance);
        if (view != null) {
            view.triggerWindowEvent(type);
        }
    }

    public void triggerShownHiddenEvent(DialogConstant target, ActionType action) {
        DialogInstance instance;
        AbstractDialogView view;
        WindowEvent event = null;
        switch (action) {
            case SHOW: {
                event = WindowEvent.SHOWN;
                break;
            }
            case HIDE: {
                event = WindowEvent.HIDDEN;
                break;
            }
        }
        if (event != null && (view = (AbstractDialogView)this.getDialogView(instance = this.getCurrentDialogInstance(target))) != null) {
            view.triggerWindowEvent(event);
        }
    }

    @Override
    public boolean isOpen(DialogConstant target) {
        DialogInstance instance = this.getCurrentDialogInstance(target);
        return instance != null && (this.openDialogs.contains(instance) || this.openDialogBoxes.contains(instance));
    }

    @Override
    public boolean isShown(DialogConstant target) {
        DialogInstance instance = this.getCurrentDialogInstance(target);
        if (instance != null) {
            return this.isShown(instance);
        }
        return false;
    }

    private boolean isShown(DialogInstance instance) {
        Boolean dialogBoxShown;
        if (this.openDialogs.contains(instance)) {
            AbstractDialogView view = (AbstractDialogView)this.getDialogView(instance);
            return view.isShown();
        }
        return this.openDialogBoxes.contains(instance) && (dialogBoxShown = this.shown.get(instance)) != null && dialogBoxShown != false;
    }

    @Override
    public void open(DialogConstant dialogConstant) {
        this.open(dialogConstant, false, false);
    }

    @Override
    public void open(DialogConstant dialogConstant, boolean newDialog) {
        this.open(dialogConstant, newDialog, false);
    }

    private void open(final DialogConstant dialogConstant, final boolean newDialog, final boolean fromExternal) {
        this.guiInvoke(new GuiTask("open"){

            @Override
            public void run() {
                DialogInstance instance = AbstractApplicationView.this.getDialogInstance(dialogConstant, newDialog, fromExternal);
                if (dialogConstant.getWindowType() == DialogConstant.WindowType.DIALOG_BOX) {
                    if (!AbstractApplicationView.this.openDialogBoxes.contains(instance)) {
                        AbstractApplicationView.this.openDialogBoxes.add(instance);
                        if (instance instanceof DialogInstanceKeyFromExternal) {
                            AbstractApplicationView.this.sendPushMessage();
                        }
                    }
                    AbstractApplicationView.this.show(instance);
                } else {
                    if (AbstractApplicationView.this.openDialogs.contains(instance)) {
                        AbstractApplicationView.this.sendElevateMessage();
                    } else {
                        AbstractApplicationView.this.sendPushMessage();
                    }
                    AbstractApplicationView.this.openDialogs.remove(instance);
                    AbstractApplicationView.this.openDialogs.add(instance);
                }
                AbstractApplicationView.this.triggerDialogEvent(instance, WindowEvent.OPENED);
            }
        });
    }

    @Override
    public void close(final DialogConstant dialogConstant) {
        this.guiInvoke(new GuiTask("close"){

            @Override
            public void run() {
                DialogInstance instance = AbstractApplicationView.this.getCurrentDialogInstance(dialogConstant);
                if (instance != null) {
                    if (AbstractApplicationView.this.openDialogs.contains(instance)) {
                        instance = (DialogInstance)AbstractApplicationView.this.openDialogs.get(AbstractApplicationView.this.openDialogs.indexOf(instance));
                    } else if (AbstractApplicationView.this.openDialogBoxes.contains(instance)) {
                        instance = (DialogInstance)AbstractApplicationView.this.openDialogBoxes.get(AbstractApplicationView.this.openDialogBoxes.indexOf(instance));
                    }
                }
                if (instance != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("closing " + dialogConstant));
                    }
                    if (AbstractApplicationView.this.openDialogs.remove(instance) || AbstractApplicationView.this.openDialogBoxes.remove(instance)) {
                        AbstractApplicationView.this.sendElevateMessage();
                        AbstractApplicationView.this.sendPopMessage();
                    }
                    AbstractApplicationView.this.triggerDialogEvent(instance, WindowEvent.CLOSED);
                    AbstractApplicationView.this.clearObject(instance);
                    AbstractApplicationView.this.removeInstance(instance);
                }
            }
        });
    }

    public void removeInstance(DialogInstance instance) {
        this.dialogViews.remove(instance);
        this.viewModels.remove(instance);
        this.getApplicationController().removeDialogInstance(instance);
    }

    @Override
    public void show(final DialogConstant dialogConstant) {
        this.guiInvoke(new GuiTask("show"){

            @Override
            public void run() {
                DialogInstance instance = AbstractApplicationView.this.getCurrentDialogInstance(dialogConstant);
                if (instance != null) {
                    AbstractApplicationView.this.show(instance);
                }
            }
        });
    }

    protected void show(DialogInstance instance) {
        DialogInstance stackInstance = null;
        if (this.openDialogs.contains(instance)) {
            stackInstance = this.openDialogs.get(this.openDialogs.indexOf(instance));
            this.openDialogs.remove(stackInstance);
            this.openDialogs.add(stackInstance);
        } else if (this.openDialogBoxes.contains(instance)) {
            this.shown.put(instance, Boolean.TRUE);
        }
        this.sendElevateMessage();
        this.getApplicationController().setActiveDialogInstance(instance);
    }

    @Override
    public void hide(final DialogConstant dialogConstant) {
        this.guiInvoke(new GuiTask("hide"){

            @Override
            public void run() {
                DialogInstance instance = AbstractApplicationView.this.getCurrentDialogInstance(dialogConstant);
                if (instance != null) {
                    if (AbstractApplicationView.this.openDialogs.contains(instance)) {
                        DialogInstance stackInstance = (DialogInstance)AbstractApplicationView.this.openDialogs.get(AbstractApplicationView.this.openDialogs.indexOf(instance));
                        AbstractApplicationView.this.openDialogs.remove(stackInstance);
                        AbstractApplicationView.this.openDialogs.add(0, stackInstance);
                    } else if (AbstractApplicationView.this.openDialogBoxes.contains(instance)) {
                        AbstractApplicationView.this.shown.put(instance, Boolean.FALSE);
                    }
                }
            }
        });
    }

    @Override
    public void clearObject(final DialogConstant dialogConstant) {
        this.guiInvoke(new GuiTask("clearObject"){

            @Override
            public void run() {
                DialogInstance instance = AbstractApplicationView.this.getCurrentDialogInstance(dialogConstant);
                if (instance != null) {
                    AbstractApplicationView.this.clearObject(instance);
                }
            }
        });
    }

    private void clearObject(DialogInstance instance) {
        AbstractDialogView view = (AbstractDialogView)this.getDialogView(instance);
        if (view != null) {
            view.clearDialog();
        }
    }

    protected List<DialogInstance> getOpenDialogs() {
        return this.openDialogs;
    }

    public List<DialogInstance> getOpenDialogBoxes() {
        ArrayList<DialogInstance> boxes = new ArrayList<DialogInstance>();
        for (DialogInstance dialog : this.openDialogBoxes) {
            if (!this.isShown(dialog)) continue;
            boxes.add(dialog);
        }
        return boxes;
    }

    public JVineDispatcherContext getDispatcherContext() {
        BlockingMessageCallback callBack = this.getBlockinMessageCallback();
        return this.getDispatcherContext(callBack);
    }

    private BlockingMessageCallback getBlockinMessageCallback() {
        BlockingMessageCallback callBack = (BlockingMessageCallback)ServiceLoader.getService(BlockingMessageCallback.class);
        if (callBack instanceof UAMessageCallback) {
            UAMessageCallback uaMsgCb = (UAMessageCallback)callBack;
            JVineAppController jAppCtrl = JVineAppController.getInstance(this.applicationController);
            uaMsgCb.setGuiActionQueue(jAppCtrl.getActionQueue());
        }
        return callBack;
    }

    public JVineDispatcherContext getDispatcherContext(final MessageCallback messageCallback) {
        return new JVineDispatcherContext(){

            @Override
            public AbstractApplicationView getApplicationView() {
                return AbstractApplicationView.this;
            }

            @Override
            public MessageCallback getMessageCallback() {
                return messageCallback;
            }

            public String toString() {
                return "JVineDispatcherContext [" + AbstractApplicationView.this.getApplicationController().getApplicationName() + "]";
            }

            @Override
            public InteractionThreadPolicy getInteractionThreadPolicy() {
                return messageCallback.getInteractionThreadPolicy();
            }
        };
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.getMessageDispatcher(this.getDispatcherContext());
    }

    public MessageDispatcher getMessageDispatcher(DispatcherContext dispatcherContext) {
        return MessageSystem.getMessageDispatcher((DispatcherContext)dispatcherContext);
    }

    protected void guiInvoke(GuiTask method) {
        if (ThreadManager.isWorkerThread()) {
            try {
                this.getApplicationController().invokeOnGui(method);
            }
            catch (InvocationTargetException e) {
                MessageDispatcher messageDispatcher = this.getMessageDispatcher();
                Message msg = MessageSystem.getMessageFactory().getMessage("-1517", new Object[]{method.toString()});
                msg.setReplString("OK");
                msg.setException((Throwable)e);
                messageDispatcher.dispatch("-1517", new Object[]{msg});
            }
        } else {
            method.run();
        }
    }

    private DialogInstance getFirstDialogInstance() {
        DialogConstant dialog = this.getFirstDialog();
        if (this.getDialogName(dialog).equals(this.getEmptyDialogName())) {
            return null;
        }
        DialogInstance instance = this.getApplicationController().getCurrentDialogInstance(dialog);
        if (instance == null) {
            instance = this.getApplicationController().createDialogInstance(this.getFirstDialog(), -1);
        }
        return instance;
    }

    private DialogInstance getCurrentDialogInstance(DialogConstant dialog) {
        return this.getApplicationController().getCurrentDialogInstance(dialog);
    }

    private DialogInstance getDialogInstance(DialogConstant dialog, boolean newInstance, boolean fromExternal) {
        DialogInstance instance = null;
        if (!newInstance) {
            instance = this.getCurrentDialogInstance(dialog);
        }
        if (instance == null) {
            instance = this.getApplicationController().createDialogInstance(dialog, -1);
        }
        if (fromExternal) {
            instance = new DialogInstanceKeyFromExternal(instance);
        }
        return instance;
    }

    @Override
    public String getDialogTitle(DialogInstance instance) {
        String title = this.dialogTitle.get(instance);
        if (title == null) {
            title = instance.getDialogConstant().getTitle();
            if (instance.getDialogInstanceNumber() > 1) {
                title = title + " #" + instance.getDialogInstanceNumber();
            }
        }
        return title;
    }

    @Override
    public void setDialogTitle(DialogInstance instance, String title) {
        if (title == null) {
            this.dialogTitle.remove(instance);
        } else {
            this.dialogTitle.put(instance, title);
        }
    }

    public List<SystemMessage> getOutputMessages() {
        return this.outputMessages;
    }

    public void sendPushMessage() {
        String applicationName = this.getApplicationController().getApplicationName();
        SystemMessage pushMessage = SystemMessage.STACK_PUSH_TEMPLATE.payload(new SystemMessage(applicationName, "", ""));
        this.getOutputMessages().add(pushMessage);
    }

    public void sendElevateMessage() {
        String applicationName = this.getApplicationController().getApplicationName();
        SystemMessage elevateMessage = SystemMessage.STACK_ELEVATE_TEMPLATE.payload(new SystemMessage(applicationName, "", ""));
        this.getOutputMessages().add(elevateMessage);
    }

    public void sendPopMessage() {
        this.getOutputMessages().add(SystemMessage.STACK_POP_TEMPLATE);
    }

    public boolean hasDirtyDialogs() {
        for (ViewModel viewModel : this.viewModels.values()) {
            if (viewModel.getChangedFields().size() <= 0) continue;
            DialogController ctrl = viewModel.getDialogController();
            ArrayList changedFields = Lists.newArrayList();
            for (DialogObjectConstant field : viewModel.getChangedFields()) {
                RoleConstant ar;
                if (field.getAttribute() == null || field.getAttribute().getAttributeRole() == null || (ar = field.getAttribute().getAttributeRole()) instanceof UsertypeRoleConstant || ctrl.checkChange(ar, CheckType.CLOSE)) continue;
                changedFields.add(field);
            }
            if (changedFields.size() <= 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dirty fields for dialog " + ctrl.getDialogConstant().getG9Name() + ":"));
                for (DialogObjectConstant field : changedFields) {
                    log.debug((Object)("Dirty field: " + field.getInternalName() + " (G9Name= " + field.getG9Name() + ")"));
                }
            }
            return true;
        }
        return false;
    }
}

