/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.view;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.esito.jvine.controller.FieldData;
import no.esito.jvine.controller.JVineController;
import no.esito.jvine.validation.ValidationManager;
import no.esito.jvine.validation.ValidationManagerFactory;
import no.esito.jvine.view.AbstractApplicationView;
import no.esito.jvine.view.DefaultPropertyManager;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogController;
import no.g9.client.core.controller.DialogInstance;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.converter.FieldConvertContext;
import no.g9.client.core.converter.JodaDateTimeConverter;
import no.g9.client.core.converter.LocalDateConverter;
import no.g9.client.core.converter.LocalDateTimeConverter;
import no.g9.client.core.converter.LocalTimeConverter;
import no.g9.client.core.converter.NumberConverter;
import no.g9.client.core.util.DialogObjectConstantHelper;
import no.g9.client.core.validator.FieldValidator;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationPolicy;
import no.g9.client.core.validator.ValidationResult;
import no.g9.client.core.view.DialogView;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.table.TableModel;
import no.g9.client.core.view.tree.TreeModel;
import no.g9.client.core.view.tree.TreeNode;
import no.g9.os.AttributeConstant;
import no.g9.os.RoleConstant;
import no.g9.service.G9Spring;
import no.g9.support.TypeTool;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;
import no.g9.support.convert.ConvertException;

public class ViewModelImpl
implements ViewModel {
    private static final Logger log = Logger.getLogger(ViewModel.class);
    private DialogInstance instance;
    private AbstractApplicationView applicationView;
    private Map<DialogObjectConstant, Object> fields = new HashMap<DialogObjectConstant, Object>();
    private Map<RoleConstant, Collection<DialogObjectConstant>> fieldsForRole = new HashMap<RoleConstant, Collection<DialogObjectConstant>>();
    private Set<DialogObjectConstant> changedFields = new HashSet<DialogObjectConstant>();
    private Map<RoleConstant, TableModel<? extends ListRow>> tableModels = new HashMap<RoleConstant, TableModel<? extends ListRow>>();
    private Map<DialogObjectConstant, TreeModel<? extends TreeNode, ? extends ListRow>> treeModels = new HashMap<DialogObjectConstant, TreeModel<? extends TreeNode, ? extends ListRow>>();
    private Map<DialogObjectConstant, RoleConstant> listRoles = new HashMap<DialogObjectConstant, RoleConstant>();
    private Map<RoleConstant, Integer> listSelections = new HashMap<RoleConstant, Integer>();
    private Map<DialogObjectConstant, FieldConvertContext> convertContexts = new HashMap<DialogObjectConstant, FieldConvertContext>();
    private Map<DialogObjectConstant, ValidateContext> validateContexts = new HashMap<DialogObjectConstant, ValidateContext>();
    private DefaultPropertyManager propertyManager = new DefaultPropertyManager();
    private ValidationManager validationManager;

    public ViewModelImpl(DialogInstance dialog, AbstractApplicationView applicationView) {
        this.instance = dialog;
        this.applicationView = applicationView;
    }

    public Map<DialogObjectConstant, Object> getFields() {
        return this.fields;
    }

    public Map<DialogObjectConstant, RoleConstant> getListRoles() {
        return this.listRoles;
    }

    public Object getField(DialogObjectConstant field) {
        return this.getFields().get(field);
    }

    public void setField(DialogObjectConstant field, Object value) {
        Object oldValue = this.getField(field);
        if (TypeTool.viewFieldDiffer((Object)value, (Object)oldValue)) {
            this.setChanged(field, true);
        }
        this.getFields().put(field, value);
    }

    public void addRoleField(RoleConstant role, DialogObjectConstant field) {
        Collection<DialogObjectConstant> roleFields = this.fieldsForRole.get(role);
        if (roleFields == null) {
            roleFields = new HashSet<DialogObjectConstant>();
            this.fieldsForRole.put(role, roleFields);
        }
        roleFields.add(field);
    }

    public void addRoleTableModel(RoleConstant role, DialogObjectConstant listConst, TableModel<? extends ListRow> tableModel) {
        this.setTableModel(role, tableModel);
        this.listRoles.put(listConst, role);
    }

    public void copyToEquivalentFields(DialogObjectConstant field, Object value) {
        AttributeConstant attribute = field.getAttribute();
        for (DialogObjectConstant otherField : this.getAttributeFields(attribute)) {
            if (field == otherField) continue;
            try {
                Object otherValue = value;
                if (ViewModelImpl.hasConverter(field)) {
                    Object attributeValue = this.convertToModelInternal(field, value);
                    otherValue = this.convertToViewInternal(otherField, attributeValue);
                }
                this.setField(otherField, otherValue);
                this.setChanged(otherField, false);
            }
            catch (ConvertException convertException) {}
        }
    }

    @Override
    public Collection<DialogObjectConstant> getRoleFields(RoleConstant role) {
        Collection<DialogObjectConstant> roleFields = this.fieldsForRole.get(role);
        if (roleFields == null) {
            roleFields = new HashSet<DialogObjectConstant>();
            this.fieldsForRole.put(role, roleFields);
        }
        return roleFields;
    }

    @Override
    public void clearViewModel() {
        for (DialogObjectConstant dialogObjectConstant : this.getFields().keySet()) {
            this.setFieldValue(dialogObjectConstant, null);
        }
        for (TableModel tableModel : this.tableModels.values()) {
            tableModel.clear();
        }
        for (TreeModel treeModel : this.treeModels.values()) {
            treeModel.clear();
        }
        this.changedFields.clear();
    }

    @Override
    public boolean isChanged(DialogObjectConstant field) {
        return this.changedFields.contains(field);
    }

    @Override
    public void setChanged(DialogObjectConstant field, boolean changed) {
        if (changed) {
            this.changedFields.add(field);
        } else {
            this.changedFields.remove(field);
        }
    }

    @Override
    public Collection<DialogObjectConstant> getChangedFields() {
        return Collections.unmodifiableCollection(this.changedFields);
    }

    @Override
    public Collection<AttributeConstant> getChangedAttributes(RoleConstant role) {
        HashSet<AttributeConstant> changedAttributes = new HashSet<AttributeConstant>();
        for (DialogObjectConstant field : this.changedFields) {
            if (!field.getAttribute().getAttributeRole().equals(role)) continue;
            changedAttributes.add(field.getAttribute());
        }
        return changedAttributes;
    }

    @Override
    public Object getFieldValue(DialogObjectConstant field) {
        Object fieldValue = this.getField(field);
        if (ViewModelImpl.hasConverter(field)) {
            fieldValue = this.convertToModel(field, fieldValue);
        }
        return fieldValue;
    }

    @Override
    public void setFieldValue(DialogObjectConstant field, Object fieldValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setFieldValue: " + field + "[" + fieldValue + "]"));
        }
        if (ViewModelImpl.hasConverter(field)) {
            fieldValue = this.convertToView(field, fieldValue);
        }
        this.setField(field, fieldValue);
        this.setChanged(field, false);
    }

    public void setFieldValues(ListRow row) {
        for (DialogObjectConstant field : row.getFields()) {
            this.setField(field, row.getValue(field));
            this.setChanged(field, false);
            this.copyToEquivalentFields(field, row.getValue(field));
        }
    }

    public void clearFieldValues(ListRow row) {
        for (DialogObjectConstant field : row.getFields()) {
            this.setField(field, null);
            this.setChanged(field, false);
            this.copyToEquivalentFields(field, null);
        }
    }

    @Override
    public Collection<DialogObjectConstant> getAttributeFields(AttributeConstant attribute) {
        HashSet<DialogObjectConstant> attributeFields = new HashSet<DialogObjectConstant>();
        Collection<DialogObjectConstant> roleFields = this.getRoleFields(attribute.getAttributeRole());
        for (DialogObjectConstant roleField : roleFields) {
            if (roleField.getAttribute() != attribute) continue;
            attributeFields.add(roleField);
        }
        return attributeFields;
    }

    @Override
    public <T extends ListRow> List<T> getDisplayList(RoleConstant role) {
        TableModel<T> tableModel = this.getTableModel(role);
        if (tableModel == null) {
            return null;
        }
        return tableModel.getTableView();
    }

    @Override
    public <T extends ListRow> TableModel<T> getTableModel(RoleConstant role) {
        TableModel<? extends ListRow> tableModel = this.tableModels.get(role);
        return tableModel;
    }

    @Override
    public <T extends ListRow> void setTableModel(RoleConstant role, TableModel<T> tableModel) {
        this.tableModels.put(role, tableModel);
    }

    @Override
    public <T extends TreeNode, L extends ListRow> TreeModel<T, L> getTreeModel(DialogObjectConstant attribute) {
        return this.treeModels.get(attribute);
    }

    @Override
    public void setTreeModel(DialogObjectConstant role, TreeModel<? extends TreeNode, ? extends ListRow> treeModel) {
        this.treeModels.put(role, treeModel);
    }

    @Override
    public <M, T> AttributeConverter<M, T> getConverter(DialogObjectConstant field) {
        Object converter = null;
        if (field.getAttribute() != null) {
            String converterId = field.getAttribute().getConverterId();
            if (converterId != null) {
                converter = (JodaDateTimeConverter)G9Spring.getBean(AttributeConverter.class, (String)converterId);
            }
            if (DialogObjectConstantHelper.isJodaType(field)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new Joda DateTime converter for " + field + ", chained with " + converterId));
                }
                converter = new JodaDateTimeConverter(converter, field.getAttribute().getAttributeType());
            }
            if (DialogObjectConstantHelper.isLocalDate(field)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new LocalDate converter for " + field + ", chained with " + converterId));
                }
                converter = new LocalDateConverter((AttributeConverter<LocalDate, Date>)converter);
            }
            if (DialogObjectConstantHelper.isLocalTime(field)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new LocalTime converter for " + field + ", chained with " + converterId));
                }
                converter = new LocalTimeConverter((AttributeConverter<LocalTime, Date>)converter);
            }
            if (DialogObjectConstantHelper.isLocalDateTime(field)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new LocalDateTime converter for " + field + ", chained with " + converterId));
                }
                converter = new LocalDateTimeConverter((AttributeConverter<LocalDateTime, Date>)converter);
            }
            if (String.class != field.getAttribute().getAttributeType() && DialogObjectConstantHelper.isAutoCompleteEntry(field)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new Number converter for " + field + ", chained with " + converterId));
                }
                converter = new NumberConverter(converter, field.getAttribute().getAttributeType());
            }
        }
        return converter;
    }

    @Override
    public FieldValidator getValidator(DialogObjectConstant field) {
        String validatorId = field.getAttribute().getValidatorId();
        return (FieldValidator)G9Spring.getBean(FieldValidator.class, (String)validatorId);
    }

    private Object convertToModel(DialogObjectConstant field, Object fieldValue) {
        try {
            return this.convertToModelInternal(field, fieldValue);
        }
        catch (ConvertException e) {
            JVineController.getInstance(this.getDialogController()).addConverterException(e);
            return null;
        }
    }

    <M, T> M convertToModelInternal(DialogObjectConstant field, T fieldValue) throws ConvertException {
        AttributeConverter<M, T> converter = this.getConverter(field);
        FieldConvertContext ctx = this.getConvertContext(field);
        return (M)converter.toModel(fieldValue, (ConvertContext)ctx);
    }

    private <M, T> T convertToView(DialogObjectConstant field, M fieldValue) {
        try {
            return this.convertToViewInternal(field, fieldValue);
        }
        catch (ConvertException e) {
            JVineController.getInstance(this.getDialogController()).addConverterException(e);
            return null;
        }
    }

    <M, T> T convertToViewInternal(DialogObjectConstant field, M fieldValue) throws ConvertException {
        AttributeConverter<M, T> converter = this.getConverter(field);
        FieldConvertContext ctx = this.getConvertContext(field);
        return (T)converter.fromModel(fieldValue, (ConvertContext)ctx);
    }

    public Map<ValidationResult, ValidateContext> validateField(DialogObjectConstant field, Object value) {
        return this.validateField(null, field, value);
    }

    public Map<ValidationResult, ValidateContext> validateField(ListRow listRow, DialogObjectConstant field, Object value) {
        if (this.validationManager == null) {
            this.validationManager = ValidationManagerFactory.create(null, this.getDialogController());
        }
        ValidateContext ctx = this.getValidateContext(listRow, field);
        return this.validationManager.validate(field, value, ValidationPolicy.Policy.ON_CHANGE, ctx);
    }

    static boolean hasConverter(DialogObjectConstant field) {
        if (field.getAttribute() != null) {
            if (field.getAttribute().getConverterId() != null) {
                return true;
            }
            if (DialogObjectConstantHelper.isJodaType(field)) {
                return true;
            }
            if (DialogObjectConstantHelper.isJavaTimeType(field)) {
                return true;
            }
            if (String.class != field.getAttribute().getAttributeType() && DialogObjectConstantHelper.isAutoCompleteEntry(field)) {
                return true;
            }
        }
        return false;
    }

    FieldConvertContext getConvertContext(DialogObjectConstant field) {
        FieldConvertContext ctx = this.convertContexts.get(field);
        if (ctx == null) {
            ctx = new FieldConvertContext(this.getDialogController(), field);
            this.convertContexts.put(field, ctx);
        }
        return ctx;
    }

    public boolean hasValidator(DialogObjectConstant field) {
        return field.getAttribute().getValidatorId() != null || this.applicationView.getDialogView(this.instance).isMandatory(field);
    }

    ValidateContext getValidateContext(ListRow listRow, DialogObjectConstant field) {
        ValidateContext ctx = this.validateContexts.get(field);
        if (ctx == null) {
            ctx = new ValidateContext(this.getDialogController(), listRow, field);
            this.validateContexts.put(field, ctx);
        }
        return ctx;
    }

    @Override
    public DialogController getDialogController() {
        return this.applicationView.getDialogController(this.instance);
    }

    public <T extends DialogView> T getDialogView() {
        return this.applicationView.getDialogView(this.instance);
    }

    @Override
    public FieldData getCurrentFieldData(RoleConstant role) {
        FieldData fieldData = new FieldData(role);
        Collection<DialogObjectConstant> roleFields = this.getRoleFields(role);
        for (DialogObjectConstant field : roleFields) {
            fieldData.setFieldValue(field.getAttribute(), this.getFieldValue(field));
        }
        return fieldData;
    }

    @Override
    public Collection<FieldData> getAllFieldData(RoleConstant role) {
        ArrayList<FieldData> fieldDataList = new ArrayList<FieldData>();
        TableModel tableModel = this.getTableModel(role);
        for (ListRow row : tableModel.getTableData()) {
            fieldDataList.add(this.getRowFieldData(row, role));
        }
        return fieldDataList;
    }

    @Override
    public FieldData getRowFieldData(ListRow row, RoleConstant role) {
        FieldData fieldData = new FieldData(role);
        for (DialogObjectConstant field : row.getFields()) {
            Object value = row.getValue(field);
            if (ViewModelImpl.hasConverter(field)) {
                value = this.convertToModel(field, value);
            }
            fieldData.setFieldValue(field.getAttribute(), value);
        }
        return fieldData;
    }

    public DefaultPropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void resetListRowSelection(RoleConstant role) {
        List list = this.getTableModel(role).getTableData();
        if (this.listSelections.get(role) != null) {
            int singleRow;
            int rowNo = this.listSelections.get(role);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Resetting to row: " + rowNo + ", selected rows: " + this.getSelectedRowNos(role)));
            }
            for (ListRow row : list) {
                row.setSelected(Boolean.FALSE);
            }
            ListRow row = (ListRow)list.get(rowNo);
            if (row != null) {
                row.setSelected(Boolean.TRUE);
            }
            if ((singleRow = this.getSingleSelectedRowNo(role)) == -1) {
                this.listSelections.remove(role);
                this.clearFieldValues(row);
                JVineController.getInstance(this.getDialogController()).clearCurrent(role);
            }
        } else {
            for (ListRow row : list) {
                row.setSelected(Boolean.FALSE);
            }
        }
    }

    public boolean setListRowSelection(boolean selected, RoleConstant role, int rowNo, ListRow emptyRow) {
        List list = this.getDisplayList(role);
        TableModel<ListRow> tableModel = this.getTableModel(role);
        if (selected && tableModel.getSelectionModel() == TableModel.SelectionModel.NO_SELECT) {
            log.trace((Object)("Attempting to select row, but current selection model of " + role + " prohibits selection."));
            tableModel.setSelected((ListRow)list.get(rowNo), false);
            return false;
        }
        tableModel.setSelected((ListRow)list.get(rowNo), selected);
        log.trace((Object)("Selection state: " + selected + ", row: " + rowNo));
        int singleSelectedRowNo = this.getSingleSelectedRowNo(role);
        log.trace((Object)("Single: " + singleSelectedRowNo));
        if (singleSelectedRowNo != -1) {
            this.listSelections.put(role, singleSelectedRowNo);
        } else {
            this.listSelections.remove(role);
        }
        return true;
    }

    private int getSingleSelectedRowNo(RoleConstant role) {
        int numSelected = 0;
        int rowNo = 0;
        for (ListRow row : this.getTableModel(role).getTableView()) {
            if (!row.isRowSelected()) continue;
            ++numSelected;
            rowNo = this.getTableModel(role).getTableView().indexOf(row);
        }
        return numSelected == 1 ? rowNo : -1;
    }

    private List<Integer> getSelectedRowNos(RoleConstant role) {
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        for (ListRow row : this.getTableModel(role).getTableView()) {
            if (!row.isRowSelected()) continue;
            selectedRows.add(this.getTableModel(role).getTableView().indexOf(row));
        }
        return selectedRows;
    }

    public void updateTableFieldValues(RoleConstant role) {
        TableModel tableModel = this.getTableModel(role);
        if (tableModel != null) {
            if (tableModel.getSelectionCount() == 1) {
                ListRow selectedRow = (ListRow)tableModel.getSelected().get(0);
                this.setFieldValues(selectedRow);
                JVineController.getInstance(this.getDialogController()).setCurrent(this.getRowFieldData(selectedRow, role));
            } else if (!tableModel.getTableData().isEmpty()) {
                ListRow firstRow = (ListRow)tableModel.getTableData().get(0);
                this.clearFieldValues(firstRow);
                JVineController.getInstance(this.getDialogController()).clearCurrent(role);
            }
        }
    }

    public DialogObjectConstant getFieldDialogObjectConstant(String internalName) {
        DialogObjectConstant retVal = null;
        for (DialogObjectConstant field : this.fields.keySet()) {
            if (!field.getInternalName().equals(internalName)) continue;
            retVal = field;
        }
        return retVal;
    }
}

