/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.converter;

import java.text.MessageFormat;
import no.g9.exception.G9BaseException;
import no.g9.support.convert.AttributeConverter;
import no.g9.support.convert.ConvertContext;
import no.g9.support.convert.ConvertException;

public class StringConverter<M>
implements AttributeConverter<M, String> {
    private Class<M> modelType;
    private MessageFormat format;

    public void setModelTypeClass(String className) {
        try {
            this.modelType = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new G9BaseException("Unable to get model type class", (Throwable)e);
        }
    }

    public void setFormat(String format) {
        this.format = new MessageFormat(format);
    }

    public Class<M> getModelType() {
        return this.modelType;
    }

    public Class<String> getTargetType() {
        return String.class;
    }

    public M toModel(String value, ConvertContext context) throws ConvertException {
        if (value == null) {
            return null;
        }
        try {
            Object[] objs = this.format.parse(value);
            return (M)objs[0];
        }
        catch (Exception e) {
            throw new ConvertException(context, (Object)value, "Unable to parse", (Throwable)e);
        }
    }

    public String fromModel(Object value, ConvertContext context) throws ConvertException {
        if (value == null) {
            return null;
        }
        try {
            return this.format.format(new Object[]{value});
        }
        catch (Exception e) {
            throw new ConvertException(context, value, "Unable to format", (Throwable)e);
        }
    }
}

