/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Observable;
import no.esito.jvine.view.DefaultPropertyManager;
import no.esito.log.Logger;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.Property;
import no.g9.client.core.view.PropertyManager;

public abstract class ListRow
extends Observable
implements PropertyManager {
    private static final Logger log = Logger.getLogger(ListRow.class);
    private int dialogInstanceNumber;
    private Boolean selected;
    private Map<DialogObjectConstant, Object> values = new HashMap<DialogObjectConstant, Object>();
    private final PropertyManager propertyManager = new DefaultPropertyManager();

    public ListRow(int dialogInstanceNumber, boolean selected) {
        this.dialogInstanceNumber = dialogInstanceNumber;
        this.setSelected(selected);
    }

    public int getDialogInstanceNumber() {
        return this.dialogInstanceNumber;
    }

    public boolean isRowSelected() {
        return this.getSelected() != null && this.getSelected() != false;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Object getValue(DialogObjectConstant field) {
        return this.getValues().get(field);
    }

    public void setValue(DialogObjectConstant field, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setValue: " + field + "[" + value + "]"));
        }
        if (this.getFields().contains(field)) {
            this.getValues().put(field, value);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public abstract Collection<DialogObjectConstant> getFields();

    private Map<DialogObjectConstant, Object> getValues() {
        return this.values;
    }

    @Override
    public final void clear(DialogObjectConstant dialogObject, Property<?> property) {
        this.columnCheck(dialogObject);
        this.propertyManager.clear(dialogObject, property);
    }

    @Override
    public final void clearAll() {
        this.propertyManager.clearAll();
    }

    @Override
    public final void clearAll(DialogObjectConstant dialogConstant) {
        this.columnCheck(dialogConstant);
        this.propertyManager.clearAll(dialogConstant);
    }

    @Override
    public final <T> T getProperty(DialogObjectConstant dialogObject, Property<T> property) {
        this.columnCheck(dialogObject);
        return this.propertyManager.getProperty(dialogObject, property);
    }

    @Override
    public final String listProperties() {
        return this.propertyManager.listProperties();
    }

    @Override
    public final String listProperties(DialogObjectConstant dialogObject) {
        this.columnCheck(dialogObject);
        return this.propertyManager.listProperties(dialogObject);
    }

    @Override
    public final <T> void setProperty(DialogObjectConstant dialogObject, Property<T> property, T value) {
        this.columnCheck(dialogObject);
        this.propertyManager.setProperty(dialogObject, property, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.getValues();
    }

    @Override
    public boolean isPropertySet(DialogObjectConstant dialogObject, Property<?> property) {
        this.columnCheck(dialogObject);
        return this.propertyManager.isPropertySet(dialogObject, property);
    }

    private void columnCheck(DialogObjectConstant dialogObject) {
        if (!this.values.keySet().contains(dialogObject)) {
            throw new NoSuchElementException("Unknown column: " + dialogObject);
        }
    }

    protected String createBeanRef(String beanName) {
        String retVal = "#{" + beanName;
        if (this.getDialogInstanceNumber() > 1) {
            retVal = retVal + this.getDialogInstanceNumber();
        }
        return retVal + "}";
    }
}

