/*
 * Decompiled with CFR 0.152.
 */
package no.g9.client.core.view.table;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import no.esito.jvine.view.ViewModelImpl;
import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.BooleanProperty;
import no.g9.client.core.view.ListRow;
import no.g9.client.core.view.Property;
import no.g9.client.core.view.ViewModel;
import no.g9.client.core.view.table.ListRowComparator;
import no.g9.client.core.view.table.RowFilter;
import no.g9.client.core.view.table.TableData;
import no.g9.client.core.view.table.TableModel;
import no.g9.os.RoleConstant;

public class DefaultTableModel<T extends ListRow>
implements TableModel<T> {
    private final TableData<T> tableData;
    private final TableData<T> tableView;
    private final List<DialogObjectConstant> columns = new ArrayList<DialogObjectConstant>();
    private final List<RowFilter<?, ListRow>> rowFilters = new ArrayList();
    private final ViewModelImpl viewModel;
    private TableModel.SelectionModel selectionModel = TableModel.SelectionModel.DEFAULT;
    private List<ListRowComparator<T>> comparatorList;
    private ListRowComparator<T> firstComparator;

    public DefaultTableModel(List<DialogObjectConstant> columns, ViewModel viewModel) {
        this.columns.addAll(columns);
        this.viewModel = (ViewModelImpl)viewModel;
        this.tableData = new TableData(columns);
        this.tableView = new TableData(columns);
        this.tableData.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DefaultTableModel.this.filterTableView();
                DefaultTableModel.this.sortTableView();
            }
        });
    }

    public DefaultTableModel(DialogObjectConstant[] columns, ViewModel viewModel) {
        this(Arrays.asList(columns), viewModel);
    }

    @Override
    public List<T> getTableData() {
        return this.tableData;
    }

    @Override
    public List<T> getTableView() {
        return this.tableView;
    }

    @Override
    public void addRowFilter(RowFilter<?, ListRow> rowFilter) {
        this.rowFilters.add(rowFilter);
        this.filterTableView();
    }

    @Override
    public void addRowFilters(Collection<RowFilter<?, ListRow>> rowFilters) {
        this.rowFilters.addAll(rowFilters);
        this.filterTableView();
    }

    @Override
    public void removeRowFilter(RowFilter<?, ListRow> rowFilter) {
        this.rowFilters.remove(rowFilter);
        this.filterTableView();
    }

    @Override
    public void removeRowFilters(Collection<RowFilter<?, ListRow>> rowFilters) {
        this.rowFilters.removeAll(rowFilters);
        this.filterTableView();
    }

    @Override
    public void clearRowFilters() {
        this.rowFilters.clear();
    }

    @Override
    public Collection<RowFilter<?, ListRow>> getRowFilters() {
        return Collections.unmodifiableCollection(this.rowFilters);
    }

    @Override
    public void setSelectionModel(TableModel.SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        if (selectionModel == TableModel.SelectionModel.NO_SELECT) {
            this.unselectAll();
        }
    }

    @Override
    public TableModel.SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public Object getValueAt(int rowIndex, DialogObjectConstant columnIdentifier) {
        this.tableData.checkColumn(columnIdentifier);
        return ((ListRow)this.tableData.get(rowIndex)).getValue(columnIdentifier);
    }

    @Override
    public void setValueAt(int rowIndex, DialogObjectConstant columnIdentifier, Object value) {
        this.tableData.checkColumn(columnIdentifier);
        Object listrow = this.tableData.get(rowIndex);
        ((ListRow)listrow).setValue(columnIdentifier, value);
    }

    @Override
    public void filterTableView() {
        this.tableView.clear();
        for (ListRow row : this.tableData) {
            this.processRow(row, false);
        }
    }

    private void processRow(T row, boolean checkTableView) {
        boolean inTableView = checkTableView ? this.tableView.contains(row) : false;
        boolean passFilters = this.passFilters(row);
        if (passFilters && !inTableView) {
            this.tableView.add(row);
        } else if (!passFilters && inTableView) {
            this.tableView.remove(row);
        }
    }

    private boolean passFilters(T row) {
        for (RowFilter<?, ListRow> filter : this.rowFilters) {
            if (filter.passFilter((ListRow)row)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTableDataRowCount() {
        return this.tableData.size();
    }

    @Override
    public int getTableViewRowCount() {
        return this.tableView.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int indexOf(ListRow row) {
        return this.tableData.indexOf(row);
    }

    @Override
    public int toTableDataIndex(int tableViewIndex) {
        ListRow row = (ListRow)this.getTableView().get(tableViewIndex);
        return this.indexOf(row);
    }

    @Override
    public T get(int rowIndex) {
        return (T)this.tableData.get(rowIndex);
    }

    @Override
    public void insert(int rowIndex, T ... row) {
        this.insert(rowIndex, (Collection<T>)Arrays.asList(row));
    }

    @Override
    public void insert(int rowIndex, Collection<T> rows) {
        this.tableData.addAll(rowIndex, rows);
    }

    @Override
    public void add(T ... row) {
        this.add((Collection<T>)Arrays.asList(row));
    }

    @Override
    public void add(Collection<T> rows) {
        this.tableData.addAll(rows);
    }

    @Override
    public T remove(int rowIndex) {
        return (T)this.tableData.remove(rowIndex);
    }

    @Override
    public boolean remove(T ... row) {
        return this.removeAll(Arrays.asList(row));
    }

    @Override
    public boolean removeAll(Collection<T> rows) {
        boolean isChanged = this.tableData.removeAll(rows);
        this.tableView.removeAll(rows);
        return isChanged;
    }

    @Override
    public void clear() {
        this.tableData.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.tableData.isEmpty();
    }

    @Override
    public void setSelected(int rowIndex, boolean selected) {
        T row = this.get(rowIndex);
        this.setSelected(row, selected);
    }

    @Override
    public void setSelected(T row, boolean selected) {
        switch (this.selectionModel) {
            case SINGLE_SELECT: {
                this.unselectAll();
            }
            case MULTI_SELECT: {
                ((ListRow)row).setSelected(selected);
                break;
            }
            case NO_SELECT: {
                if (selected) {
                    throw new IllegalStateException("Current selection model prohibits selection of a row");
                }
                ((ListRow)row).setSelected(selected);
                break;
            }
        }
        this.viewModel.updateTableFieldValues(this.getTableRole());
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected && (this.selectionModel == TableModel.SelectionModel.SINGLE_SELECT || this.selectionModel == TableModel.SelectionModel.NO_SELECT)) {
            throw new IllegalStateException("Current selection model prohibits selection of a row");
        }
        for (ListRow row : this.tableData) {
            row.setSelected(selected);
        }
        this.viewModel.updateTableFieldValues(this.getTableRole());
    }

    private void unselectAll() {
        for (ListRow row : this.tableData) {
            row.setSelected(Boolean.FALSE);
        }
        this.viewModel.updateTableFieldValues(this.getTableRole());
    }

    @Override
    public boolean isSelected(int rowIndex) {
        Object row = this.tableData.get(rowIndex);
        return ((ListRow)row).isRowSelected();
    }

    @Override
    public List<T> getSelected() {
        ArrayList<ListRow> accum = new ArrayList<ListRow>();
        for (ListRow listRow : this.tableData) {
            if (!listRow.isRowSelected()) continue;
            accum.add(listRow);
        }
        return accum;
    }

    @Override
    public int getSelectionCount() {
        return this.getSelected().size();
    }

    protected RoleConstant getTableRole() {
        for (RoleConstant role : this.viewModel.getListRoles().values()) {
            if (this.viewModel.getTableModel(role) != this) continue;
            return role;
        }
        return null;
    }

    protected ViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setProperty(BooleanProperty.ENABLED, enabled);
    }

    @Override
    public void setRowEnabled(int rowIndex, boolean enabled) {
        this.setRowProperty((T)rowIndex, (Property)BooleanProperty.ENABLED, (Object)enabled);
    }

    @Override
    public void setRowEnabled(T row, boolean enabled) {
        this.setRowProperty(row, BooleanProperty.ENABLED, Boolean.valueOf(enabled));
    }

    @Override
    public void setColumnEnabled(DialogObjectConstant columnIdentifier, boolean enabled) {
        this.setColumnProperty(columnIdentifier, BooleanProperty.ENABLED, enabled);
    }

    @Override
    public void setCellEnabled(int rowIndex, DialogObjectConstant columnIdentifier, boolean enabled) {
        this.setCellProperty(rowIndex, columnIdentifier, BooleanProperty.ENABLED, enabled);
    }

    @Override
    public boolean isCellEnabled(int rowIndex, DialogObjectConstant columnIdentifier) {
        return this.getCellProperty(rowIndex, columnIdentifier, BooleanProperty.ENABLED);
    }

    @Override
    public void setShown(boolean shown) {
        this.setProperty(BooleanProperty.SHOWN, shown);
    }

    @Override
    public void setRowShown(int rowIndex, boolean shown) {
        this.setRowProperty((T)rowIndex, (Property)BooleanProperty.SHOWN, (Object)shown);
    }

    @Override
    public void setRowShown(T row, boolean shown) {
        this.setRowProperty(row, BooleanProperty.SHOWN, Boolean.valueOf(shown));
    }

    @Override
    public void setColumnShown(DialogObjectConstant columnIdentifier, boolean shown) {
        this.setColumnProperty(columnIdentifier, BooleanProperty.SHOWN, shown);
    }

    @Override
    public void setCellShown(int rowIndex, DialogObjectConstant columnIdentifier, boolean shown) {
        this.setCellProperty(rowIndex, columnIdentifier, BooleanProperty.SHOWN, shown);
    }

    @Override
    public boolean isCellShown(int rowIndex, DialogObjectConstant columnIdentifier) {
        return this.getCellProperty(rowIndex, columnIdentifier, BooleanProperty.SHOWN);
    }

    @Override
    public <U> void setProperty(Property<U> property, U propertyValue) {
        for (ListRow row : this.tableData) {
            this.setRowProperty(row, property, propertyValue);
        }
    }

    @Override
    public <U> void setRowProperty(int rowIndex, Property<U> property, U propertyValue) {
        Object row = this.tableData.get(rowIndex);
        this.setRowProperty(row, property, propertyValue);
    }

    @Override
    public <U> void setRowProperty(T row, Property<U> property, U propertyValue) {
        for (DialogObjectConstant columnIdentifier : this.columns) {
            ((ListRow)row).setProperty(columnIdentifier, property, propertyValue);
        }
    }

    @Override
    public <U> void setColumnProperty(DialogObjectConstant columnIdentifier, Property<U> propertyName, U value) {
        this.tableData.checkColumn(columnIdentifier);
        for (ListRow listRow : this.tableData) {
            listRow.setProperty(columnIdentifier, propertyName, value);
        }
    }

    @Override
    public <U> void setCellProperty(int rowIndex, DialogObjectConstant columnIdentifier, Property<U> propertyName, U propertyValue) {
        this.tableData.checkColumn(columnIdentifier);
        Object listRow = this.tableData.get(rowIndex);
        ((ListRow)listRow).setProperty(columnIdentifier, propertyName, propertyValue);
    }

    @Override
    public <U> U getCellProperty(int rowIndex, DialogObjectConstant columnIdentifier, Property<U> propertyName) {
        this.tableData.checkColumn(columnIdentifier);
        Object listRow = this.tableData.get(rowIndex);
        U value = ((ListRow)listRow).getProperty(columnIdentifier, propertyName);
        return value;
    }

    @Override
    public DialogObjectConstant getFirstSortingColumn() {
        ListRowComparator<T> found;
        if (this.firstComparator == null) {
            return null;
        }
        for (found = this.firstComparator; found != null && found.getSorting() == ListRowComparator.Sorting.NO_SORT; found = found.getNextComparator()) {
        }
        return found != null ? found.getColumn() : null;
    }

    @Override
    public void setFirstSortingColumn(DialogObjectConstant column) {
        if (this.comparatorList == null) {
            this.comparatorList = new ArrayList<ListRowComparator<T>>();
        }
        ListRowComparator found = null;
        for (ListRowComparator<T> comparator : this.comparatorList) {
            if (!comparator.getColumn().equals(column)) continue;
            found = comparator;
            break;
        }
        if (found == null) {
            found = new ListRowComparator(column, 0);
        }
        this.comparatorList.remove(found);
        this.comparatorList.add(0, found);
        this.firstComparator = found;
    }

    @Override
    public void sortTableView() {
        if (this.firstComparator != null) {
            Collections.sort(this.getTableView(), this.firstComparator);
        }
    }

    public List<ListRowComparator<T>> getListRowComparator() {
        return this.comparatorList;
    }

    @Override
    public void setListRowComparator(List<ListRowComparator<T>> comparatorList) {
        this.comparatorList = comparatorList;
        this.firstComparator = ListRowComparator.chainComparator(comparatorList);
    }

    @Override
    public void toggleSorting() {
        if (this.firstComparator != null) {
            this.firstComparator.toggleSorting();
        }
    }

    @Override
    public ListRowComparator.Sorting getSorting() {
        if (this.firstComparator != null) {
            return this.firstComparator.getSorting();
        }
        return null;
    }

    @Override
    public void setSorting(ListRowComparator.Sorting sortDirection) {
        if (this.firstComparator != null) {
            this.firstComparator.setSorting(sortDirection);
        }
    }

    @Override
    public void prettyPrint(PrintStream out) {
        if (this.tableData != null) {
            this.tableData.printTable(out);
            this.printSelectedLines(out);
        } else {
            out.println("No data");
        }
    }

    private void printSelectedLines(PrintStream out) {
        String line = "Selected rows are: [";
        boolean flag = false;
        for (int i = 0; i < this.tableData.size(); ++i) {
            if (!this.isSelected(i)) continue;
            flag = true;
            line = line + i + ", ";
        }
        if (flag) {
            line = line.substring(0, line.length() - ", ".length());
        }
        line = line + "]";
        out.println(line);
    }
}

