/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import java.util.concurrent.Callable;

/**
 * The callable hook method.
 * @param <V> the callable return type.
 */
public abstract class HookMethod<V> implements Callable<V> {

    private final String hookMethod;

    /**
     * Create a new hook method.
     * @param hookName the name of the hook method.
     */
    public HookMethod(String hookName) {
        this.hookMethod = hookName;
    }
        
    
    @Override
    public String toString() {
        return hookMethod;
    }
}
