/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import java.util.ArrayList;
import java.util.List;

import no.esito.log.Logger;
import no.g9.client.core.action.ActionExecutor;
import no.g9.client.core.action.G9Action;

/**
 * The simple action executor. Executes actions on the invoking thread.
 * <p><strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class SimpleActionExecutor implements ActionExecutor {

    /** The logger */
    private static Logger log = Logger.getLogger(SimpleActionExecutor.class);

    /**
     * Submits an action to the FIFO queue of actions to execute and executes it
     * when the time comes.
     * 
     * @param action the action to execute.
     * @see java.util.concurrent.ExecutorService#submit(java.util.concurrent.Callable)
     */
    @Override
    public void execute(G9Action<?> action) {
        log.info("Submitting " + action);
        try {
            log.info("Action " + action + " submitted.");
            action.call();
        } catch (Exception e) {
            log.error("Execution of action " + action + " failed", e);
        }

    }

    /**
     * Shuts down this executor, this is a no-op for this executor.
     */
    @Override
    public void shutDown() {
        // No-opp.
    }

    /**
     * Shuts down the executor, this is a no-op for this executor and the
     * returned list of un-executed runnables will always contain zero elements.
     * 
     * @return a list of un-executed runnables (zero elements).
     */
    @Override
    public List<Runnable> shutdownNow() {
        return new ArrayList<Runnable>();
    }

}
