/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.action;

import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

import no.esito.util.WeakHashSet;

/**
 * Class used to create and manage working threads.
 */
public class ThreadManager implements ThreadFactory {

    private static final Set<Thread> WORKERS = WeakHashSet.getInstance();
    
    private String threadName = "g9_";
    
    private static final AtomicInteger thread_number = new AtomicInteger(0);

    /**
     * Set the thread name prefix.
     * @param threadName the name to use on threads created by this thread manager.
     */
    public void setThreadNamePrefix(String threadName) {
        this.threadName = threadName;
        if (!this.threadName.endsWith("_")) {
            this.threadName += "_";
        }
    }
    
    private static void addWorker(Thread worker) {
        WORKERS.add(worker);
    }
    
    /**
     * Test if the invoking thread is a worker thread created by an instance
     * of ThreadManager.
     * @return <code>true</code> if the invoking thread is a working thread.
     */
    public static boolean isWorkerThread() {
        return WORKERS.contains(Thread.currentThread());
    }
    
    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, threadName + thread_number.incrementAndGet());
        ThreadManager.addWorker(t);
        return t;
    }
}
