/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.communication;

import no.g9.client.core.controller.CallBack;
import no.g9.client.core.controller.DialogConstant;

/**
 * This is a wrapper class for a call back.
 * It is used internally in jVine when a call back is in use and
 * the target of an open action is an external dialog.
 */
public class CallBackWrapper {

    /** The dialog which invoked the action. */
    public final DialogConstant actionInvoker;

    /** The target dialog. */
    public final DialogConstant callee;

    /** The call back to use. */
    public final CallBack callBack;

    /**
     * Create a new call back wrapper with the given data.
     *
     * @param actionInvoker the dialog which invoked the action
     * @param callee the target dialog
     * @param callBack the call back to use
     */
    public CallBackWrapper(DialogConstant actionInvoker, DialogConstant callee, CallBack callBack) {
        this.actionInvoker = actionInvoker;
        this.callee = callee;
        this.callBack = callBack;
    }

}
