/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.validator.ValidateContext;
import no.g9.client.core.validator.ValidationResult;

/**
 * Class used to store validation and conversion results when invoking check change.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class CheckResult {

    private Boolean checkResult;
    private final Map<ValidationResult, ValidateContext> validationResult =
            new LinkedHashMap<ValidationResult, ValidateContext>();

    private final Map<DialogObjectConstant, Collection<?>> conversionMsg =
            new LinkedHashMap<DialogObjectConstant, Collection<?>>();

    /**
     * Get the check save result.
     * 
     * @return <code>Boolean.TRUE</code> if check save succeeded
     */
    public Boolean getCheckResult() {
        return checkResult;
    }

    /**
     * Set the check save result.
     * 
     * @param checkSaveResult
     *            <code>Boolean.TRUE</code> if check save succeeded.
     */
    public void setCheckResult(Boolean checkSaveResult) {
        this.checkResult = checkSaveResult;
    }

    /**
     * Get the validation result.
     * 
     * @return map of validation results and context
     */
    public Map<ValidationResult, ValidateContext> getValidationResult() {
        return validationResult;
    }

    /**
     * Add a validation result. <em>NOTE:</em> Only failed validations should be
     * added.
     * 
     * @param validationResult
     *            a (failed) validation result
     * @param context
     *            validation context
     */
    public void addValidationResult(ValidationResult validationResult,
            ValidateContext context) {
        this.validationResult.put(validationResult, context);
    }
    
    /**
     * Add a conversion error result.
     *
     * @param messages map of messages
     */
    public void addConversionError(Map<DialogObjectConstant, Collection<?>> messages) {
        conversionMsg.putAll(messages);
    }
    
    /**
     * Get the map of conversion message errors-
     * @return map of field and conversion errors
     */
    public Map<DialogObjectConstant, Collection<?>> getConversionError() {
        return conversionMsg;
    }
    
}
