/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import no.g9.client.core.controller.DialogConstant;
import no.g9.client.core.controller.DialogInstance;

/**
 * A wrapper class for DialogInstanceKey, used for dialog instances which are
 * opened from an external source.
 */
public class DialogInstanceKeyFromExternal extends DialogInstanceKey {

    /**
     * @param dialogConstant the dialog constant denoting the dialog controller
     * @param dialogInstanceNumber the dialog instance number
     */
    public DialogInstanceKeyFromExternal(DialogConstant dialogConstant, int dialogInstanceNumber) {
        super(dialogConstant, dialogInstanceNumber);
    }

    /**
     * Copy constructor. The new object should replace the given dialog instance.
     *
     * @param instance the dialog instance to copy
     */
    public DialogInstanceKeyFromExternal(DialogInstance instance) {
        super(instance.getDialogConstant(), instance.getDialogInstanceNumber());
    }

    @Override
    public String toString() {
        return "DialogInstanceKeyFromExternal [dialogConstant=" + getDialogConstant() + ", dialogInstanceNumber="
                + getDialogInstanceNumber() + "]";
    }

}
