/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import no.g9.client.core.controller.DialogConstant;

/**
 * Identifies a dialog based on the dialog constant. The rationale behind this
 * class is that the dialog constant cannot in it self be garbage collected, 
 * thus it cannot be used as a key in a week hash map.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public class DialogKey {
    
    private final DialogConstant dialogConstant;
    
    /**
     * Constructs a new dialog key that wraps the specified dialog constant.
     * @param dialogConstant the dialog constant denoting the dialog controller.
     */
    public DialogKey(DialogConstant dialogConstant) {
        this.dialogConstant = dialogConstant;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DialogKey)) {
            return false;
        }
        DialogKey other = (DialogKey) obj;
        return dialogConstant.equals(other.dialogConstant);
    }

    @Override
    public int hashCode() {
        // 527 is the "magic" number 17 * 31 (see Effective Java item 8)
        return 527 + dialogConstant.hashCode();
    }
}
