/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import java.util.Collection;

import no.g9.client.core.validator.ValidationResult;
import no.g9.client.core.view.DialogView;
import no.g9.os.RoleConstant;
import no.g9.support.convert.ConvertException;

/**
 * The set of methods a controller implements as seen from the view.
 * <p>
 * <strong>WARNING:</strong> Although this interface is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public interface DialogStateHandler {

    /**
     * Set the instance (identified by the instance field data) as the current
     * instance.
     * 
     * @param instanceFieldData the instance field data, uniquely identifying
     *            the instance.
     */
    public void setCurrent(FieldData instanceFieldData);

    /**
     * Clears the current instance for the specified role.
     * 
     * @param role the role constant identifying the role to clear.
     */
    public void clearCurrent(RoleConstant role);

    /**
     * Views interested in receiving updates when the instance model of the
     * dialog has changed, should be registered by the dialog state handler.
     * 
     * @param dialogView the dialog view to register.
     */
    public void registerView(DialogView dialogView);

    /**
     * Returns the instances that can be reached from the specified role's
     * parent (or all known instances if this is a root).
     * 
     * @param <T> the role domain type.
     * @param role the role.
     * @return a collection of domain instances.
     */
    public <T> Collection<T> getAllInstances(OSNode<T> role);

    /**
     * Check if the specified instance is the current instance.
     * 
     * @param inst the instance to check
     * @param role the role of the instance.
     * @return <code>true</code> if the instance is the current instance.
     */
    public boolean isCurrent(Object inst, OSNode<?> role);

    /**
     * Adds a (failed) validation result to the list of validation results. This
     * then used to by the dialog controller to check if validation of the
     * dialog succeeded when obtaining.
     * <p>
     * @param validationResult the validation result.
     */
    public void addValidationResult(ValidationResult validationResult);

    /**
     * Adds a converter exception to the list of converter exceptions. *
     * @param converterException the converter exception to add.
     */
    public void addConverterException(ConvertException converterException);

}