/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.controller;

import no.g9.client.core.action.EventContext;

/**
 * The event dispatcher is responsible for dispatching events.
 * <p>
 * <strong>WARNING:</strong> Although this interface is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 */
public interface EventDispatcher {

    /**
     * Asynchronous dispatches the specified event method.
     * <p>
     * <em>WARNING:<em>Although this method is public, it should not be treated 
     * as part of the public API available to the application programmer, as it 
     * might change in incompatible ways between releases (even patches).
     * 
     * @param event the event method to dispatch.
     */
    public void dispatch(EventContext event);
}