/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.model;

import java.util.Collection;

import no.esito.jvine.controller.FieldData;
import no.esito.jvine.controller.OSNode;
import no.g9.os.OSRole;

/**
 * The client object selection role. Augments OSRole with methods needed by the
 * client side.
 * 
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be
 * treated as part of the public API, as it might change in incompatible ways
 * between releases (even patches).
 * 
 * @param <T> the domain type of the object selection role.
 */
public interface DisplayableOSRole<T> extends OSRole<T> {

    /**
     * Removes all instances belonging to this node.
     * 
     * @param intercept if true, intercept will be invoked when clearing.
     * @return a collection of changed nodes.
     */
    Collection<OSNode<?>> clear(boolean intercept);
    
    /**
     * Removes the current instances of this node and all children.
     * 
     * @param intercept if true, intercept will be invoked when clearing.
     * @return a collection of changed nodes.
     */
    Collection<OSNode<?>> clearCurrent(boolean intercept);
    
    

    /**
     * Gets the tree node that keeps the instances of this role.
     * 
     * @return the role's tree node.
     */
    TreeNode<T> getTreeNode();

    /**
     * Returns the current (displayed) instance of this role.
     * 
     * @return the current instance of this role.
     */
    T getCurrentInstance();

    /**
     * Get the view's field data for the current selected of this role.
     * 
     * @return the currently selected instance's field data.
     */
    FieldData getFieldData();

    /**
     * Gets all displayed instances of this role.
     * 
     * @return a collection of all the (roles) displayed instances.
     */
    Collection<T> getAllInstances();

    /**
     * Check if this node has any displayed values.
     * 
     * @return <code>true</code> if this node has values.
     */
    boolean hasValue();

    /**
     * Set the current instance.
     * 
     * @param instance the instance.
     * @return a collection of changed object selection nodes.
     */
    Collection<OSNode<?>> setCurrentInstance(Object instance);

    /**
     * Set the current instance identified by the supplied field data.
     * 
     * @param data the field data identifying the current instance.
     * @return a collection of changed roles.
     */
    Collection<OSNode<?>> setCurrent(FieldData data);
}
