/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.esito.jvine.view;

import java.util.List;

import no.esito.jvine.controller.JVineController;
import no.esito.util.BeanID;
import no.g9.client.core.controller.DialogObjectConstant;

/**
 * Used by jVine controller to test for context messages.
 *
 */
@BeanID("messageUtil")
public interface MessageUtil {

	/**
	 * @param jController
	 *            used to forward invocation to gui thread
	 * @return true if there are any messages in the JSF context.
	 */
	boolean hasContextMessages(JVineController jController);

	/**
	 * @param jController
	 *            used to forward invocation to gui thread
	 * @param target
	 *            the dialog object to check.
	 * @return true if there are any messages in the JSF context for the given
	 *         target.
	 */
	boolean hasContextMessages(JVineController jController,
			final DialogObjectConstant target);

	/**
	 * @param jController
	 *            forwards to gui thread
	 * @param target
	 *            target
	 * @return list
	 */
	List<Object> getContextMessages(JVineController jController,
			final DialogObjectConstant target);

	/**
	 *
	 * @param jController
	 *            forwards to gui
	 */
	void clearContextMessages(JVineController jController);

}