/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;
import no.esito.jvine.rpc.ActualParameter;
import no.esito.jvine.rpc.ActualParameter.ParameterType;
import no.g9.os.AttributeConstant;
import no.g9.os.RoleConstant;
import no.g9.support.ActionType;

/**
 * @author maw
 *
 * @param <V> type
 */
class Clearing<V> extends ActionStage<V> implements Callable<Void> {

	/**
	 * @param g9Action action
	 */
	Clearing(G9Action<V> g9Action) {
		super(g9Action);
	}

    private ParameterType getReturnType(RemoteServiceTarget target) {
        ParameterBinding<Object> returnParameter = target.getReturnParameter();
        Parameter<Object> actualParameter = returnParameter.getActualParameter();
        if (actualParameter instanceof ActualParameter<?>) {
            ActualParameter<?> tmp = (ActualParameter<?>) actualParameter;
            return tmp.getParameterType();
        }
        return null;
    }

    private RoleConstant getInvokeReturnRole(RemoteServiceTarget target) {
        ParameterBinding<Object> returnParameter = target.getReturnParameter();
        Parameter<Object> actualParameter = returnParameter.getActualParameter();
        if (actualParameter instanceof ActualParameter<?>) {
            ActualParameter<?> tmp = (ActualParameter<?>) actualParameter;
            return tmp.getRole();
        }
        return null;
    }

    private AttributeConstant getInvokeReturnAttribute(RemoteServiceTarget target) {
        ParameterBinding<Object> returnParameter = target.getReturnParameter();
        Parameter<Object> actualParameter = returnParameter.getActualParameter();
        if (actualParameter instanceof ActualParameter<?>) {
            ActualParameter<?> tmp = (ActualParameter<?>) actualParameter;
            return tmp.getAttribute();
        }
        return null;
    }

    /**
     * @param target service target
     */
    void clearRemoteTarget(RemoteServiceTarget target) {
        switch (getReturnType(target)) {
        case ATTRIBUTE:
            AttributeConstant attribute = getInvokeReturnAttribute(target);
            ga.getController().setFieldValue(attribute, null);
            break;
        case ROLE:
            RoleConstant role = getInvokeReturnRole(target);
            ga.getController().clear(role, true);
            break;
        default:
            break;
        }

    }

    /**
     * The cleared hook. Invoked before the display hook.
     *
     * @throws Exception re-throws exception from hook method.
     */
    void cleared() throws Exception {
        if (ga.shouldInvokeHook() && !ga.getDisplayableHooks().isEmpty()) {
            String methodName = "cleared";
            ThreadType threadType = ga.getThreadType(methodName, new Class[0]);
            HookMethod<Void> clearHook = new HookMethod<Void>(methodName) {
                @Override
                public Void call() throws Exception {
                    for (Displayable hook : ga.getDisplayableHooks()) {
                        hook.cleared();
                    }
                    return null;
                }

            };
            ga.getHookInvoker().execute(ga.getApplicationController(), threadType,
                    clearHook);
        }
    }

	@Override
    public Void call() throws Exception {
	    ActionType actionType = ga.getActionType();

	    switch (actionType) {
	    case FIND : // Fall through
	    case FINDALL :
	        ga.getController().clearKeepKeys(
	                (RoleConstant) ga.getActionTarget());
	        break;
	    case INVOKE :
	        clearRemoteTarget((RemoteServiceTarget) ga.getActionTarget());
	        break;
	    case DELETE :
	        ga.getController().clear((RoleConstant) ga.getActionTarget(), true);
	        break;
	    default:
	        break;
	    }
	    cleared();
	    return null;
    }

}