/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.concurrent.Callable;

import no.esito.jvine.action.HookMethod;

/** The initialized state, invokes the initialized hook
 * @param <V> type */
class Initializing<V> extends ActionStage<V> implements Callable<Void> {

	/**
	 * @param g9Action action
	 */
	Initializing(G9Action<V> g9Action) {
		super(g9Action);
	}

    /**
     * The initialized hook. This state is reached immediately before the action
     * is started by a dedicated worker thread. This hook is invoked on a dedicated
     * worker thread by default. Use the annotation {@link ThreadInfo} to control
     * which thread this method is invoked on.
     *
     * @return Void - e.g. null
     * @exception Exception re-throws exception from hook method
     */
    Void initialized() throws Exception {
        if (G9Action.getLog().isDebugEnabled()) {
            G9Action.getLog().debug(this + " initialized.");
        }
        if (ga.hasHook()) {
            ga.getActionHookList().setCurrentAction(ga);
        }
        if (ga.shouldInvokeHook()) {
            String methodName = "initialized";
            ThreadType threadType = ga.getThreadType(methodName, new Class[0]);
            HookMethod<Void> invocation = new HookMethod<Void>(methodName) {

                @Override
                public Void call() {
                    for (ActionHook<?> hook : ga.getActionHookList().getHooks()) {
                        hook.initialized();
                    }
                    return null;
                }
            };
            ga.getHookInvoker().execute(ga.getApplicationController(), threadType, invocation);
        }
        return null;
    }

	@Override
    public Void call() throws Exception {
        if (!ga.isCancelled()) {
            initialized();
            G9Action.getLog().info(ga + " initialized");
        }
        return null;

    }

}