/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

/**
 * Represents a parameter in a remote service invocation. 
 * @param <T> the parameter type (e.g. an Integer)
 */
public interface Parameter <T> {

	/**
	 * Gets the name of this parameter.
	 * @return the parameter name
	 */
	String getParameterName();

    /**
     * Get the value of the parameter.
     * 
     * @return the parameter value.
     */
    public T getParameterValue();

    /**
     * Set the value of the parameter. 
     * @param parameterValue
     *            the parameter value.
     */
    public void setParameterValue(T parameterValue);
	
	
}
