/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.action;

import java.util.List;

import no.g9.service.RemoteServiceConstant;
import no.g9.support.action.ActionTarget;

/**
 * Representation of a remote service target.
 */
public interface RemoteServiceTarget extends ActionTarget {

    /**
	 * Gets the target service.
	 *
	 * @return the target service
	 */
	RemoteServiceConstant getService();

	/**
	 * Get the list of parameter bindings.
	 *
	 * @return the parameter bindings
	 */
	List<ParameterBinding<?>> getParameterBindings();

	/**
	 * Get the return parameter binding.
	 *
	 * @param <A> the actual parameter type of the return parameter binding
	 * @return the return parameter binding
	 */
	<A> ParameterBinding<A> getReturnParameter();

	/**
	 * Get the action task - viz. the task that will perform the actual
	 * invocation of the remote service.
	 *
	 * @return the task capable of invoking the remote service
	 */
	ActionTask<?> getActionTask();

}
