/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.communication;

import java.io.IOException;

import no.g9.exception.G9BaseException;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * This class is used to hold error information for a failed
 * message.
 */
public class CommunicationError {

    /** The message which couldn't be sent. */
    public final SystemMessage failingMessage;

    /** The status code from the UA. */
    public final Integer statusCode;

    /** The error description from the UA. */
    public final String description;

    /**
     * Create a new error object from the given JSON representation.
     *
     * @param jsonRepresentation the error description as sent from the JavaScript runtime
     */
    public CommunicationError(String jsonRepresentation) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tree = mapper.readTree(jsonRepresentation);

            String receiver = tree.findValue("receiver").textValue();
            String port = tree.findValue("port").textValue();
            String payload = tree.findValue("payload").textValue();

            failingMessage = new SystemMessage(receiver, port, payload);
            statusCode = tree.findValue("statusCode").intValue();
            description = tree.findValue("description").textValue();
        } catch (IOException e) {
            throw new G9BaseException("IOException when reading the error handler object", e);
        }
    }

}
