/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

/**
 * Dialog constants implements this interface. The DialogConstant represent
 * <em>dialogs</em>. For widgets, use {@link DialogObjectConstant}
 */
public interface DialogConstant extends ViewConstant {

    /**
     * The different window types available for a window block in a dialog.
     * The jVine targets only supports one window block per dialog model,
     * and only one application window per application.
     */
    enum WindowType {
        /** The application window */
        APPLICATION_WINDOW,

        /** An ordinary document window */
        DOCUMENT_WINDOW,

        /** A dialog box, normally free floating from the MDI workspace */
        DIALOG_BOX;
    }

    /**
     * Returns the name of the constant. In the typical, generated DialogConstant, this method will
     * be implemented by the enumerator.
     * @return name representation of the constant
     * @see Enum#name()
     */
    public String name();


    /**
     * Get the g9 name of the dialog. This is the name as it appears in the
     * dialog model.
     *
     * @return the dialog name.
     */
    String getG9Name();

    /**
     * Gets an internal string representation of the dialog name. This string
     * can be used as an id, etc.
     *
     * @return the dialog's internal name.
     */
    String getInternalName();

    /**
     * Gets the title of the dialog, as given in the dialog model.
     *
     * @return the dialog's title.
     */
    String getTitle();

    /**
     * Gets the window type for the window block of the dialog model.
     *
     * @return the window type for the dialog model.
     */
    WindowType getWindowType();
    
    /**
     * Get the maximum number of concurrent instances for the dialog
     * as given in the model. If no maximum is given in the model, 
     * or the value given in the model is &lt;= 0, -1 is returned.
     *  
     * @return the maximum number of concurrent instances.
     */
    int getMaximumNumberOfInstances();

}
