/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

import no.g9.os.AttributeConstant;
import no.g9.os.RoleConstant;

/**
 * A tagging interface used to tag the generated dialog enumerations.
 * DialogObjectConstant represents <em>widgets</em>. For dialogs, use
 * {@link DialogConstant}.
 */
public interface DialogObjectConstant extends ViewConstant {

    /**
     * Get the g9 name of the dialog object. This is the name as it appears
     * in the dialog model.
     *
     * @return the dialog object name.
     */
    String getG9Name();

    /**
     * Gets an internal string representation of the dialog object name. This
     * string can be used as an id, etc.
     *
     * @return the dialog object's internal name.
     */
    String getInternalName();

    /**
     * Get the type of the dialog object.
     *
     * @return the dialog object type.
     */
    DialogObjectType getType();

    /**
     * Get the component type of the dialog object. This method
     * will return null unless the type is Component or DataComponent.
     *
     * @return the component type.
     */
    String getComponentType();

    /**
     * Returns the attribute of the data item, or null if this is not a data
     * item.
     *
     * @return the attribute of the data item
     */
    AttributeConstant getAttribute();

    /**
     * Returns the role of the repeating container, or null if this is not a
     * repeating container.
     *
     * @return the role of the repeating container
     */
    RoleConstant getRole();
    
    /**
     * Return this dialog object's label component (if applicable). Note that a label return it self.
     *
     * @return the dialogObjectConstant representing the attached label, or
     *         <code>null</code> if no label is defined.no label
     */
    DialogObjectConstant getLabelComponent();

    /**
     * Get the message id of this component.
     *
     * @return the message id
     */
    public String getMessageID();

    /**
     * Get the index of this dialog object in the Tab Order of the window block.
     * For dialog objects which cannot be part of the Tab Order, 0 is returned.
     * For dialog objects which have been removed from the Tab Order in the dialog model, -1 is returned.
     *
     * @return the tab index
     */
    int getTabIndex();

}
