/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.controller;

import java.util.Collection;

import no.g9.support.action.ActionTarget;

/**
 * All element constants in a dialog (including the dialog)
 * are tagged with this interface.
 */
public interface ViewConstant extends ActionTarget {

    /**
     * Get the parent component of this component. Dialogs return <code>null</code>
     * @return the parent component or <code>null</code> if this is a dialog.
     */
    ViewConstant getParent();
    
    /** 
     * Get all components
     * @return a collection with all the declared constants.
     */
    Collection<ViewConstant> getAll();

}
