/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.message;

import no.g9.client.core.view.ApplicationView;
import no.g9.message.DispatcherContext;

/**
 * Dispatcher context used by jVine.
 */
public interface JVineDispatcherContext extends DispatcherContext {


	/**
	 * Gets the application view used in this context.
	 * @return The application view.
	 */
	public ApplicationView getApplicationView();

	/**
	 * Gets the message call back object.
	 * @return the message call back
	 */
	public MessageCallback getMessageCallback();

	/**
	 * Get the interaction thread policy which should be used by the interactor.
	 * @return the interaction thread policy
	 */
	public InteractionThreadPolicy getInteractionThreadPolicy();
}
