/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

/**
 * A data class for events with a (new) value. The event type and the value object
 * is stored in the object, and can be used for transferring the data from an event
 * handler to the action handling method.
 */
public class ValueEvent {

    /**
     * Create a new value event with the given event type and value.
     *
     * @param eventType the event type which triggered an event 
     * @param value the value to be transferred with the event
     */
    public ValueEvent(String eventType, Object value) {
        this.eventType = eventType;
        this.value = value;
    }

    private final String eventType;

    private final Object value;

    /**
     * @return the event type
     */
    public String getEventType() {
        return eventType;
    }

    /**
     * @return the value
     */
    public Object getValue() {
        return value;
    }

}
