/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view;

/**
 * Enum for all window block events. The title is the string as shown in the
 * dialog model in G9.
 */
public enum WindowEvent {

    /** The "Got Focus" event */
    GOT_FOCUS("Got Focus"),

    /** The "Lost Focus" event */
    LOST_FOCUS("Lost Focus"),

    /** The "Opened" event */
    OPENED("Opened"),

    /** The "Closed" event */
    CLOSED("Closed"),

    /** The "Shown" event */
    SHOWN("Shown"),

    /** The "Hidden" event */
    HIDDEN("Hidden"),

    /** The "Iconized" event */
    ICONIZED("Iconized"),

    /** The "Restored" event */
    RESTORED("Restored"),

    /** The "WM Close" event */
    WM_CLOSE("WM Close"),

    /** The "Accelerator" event */
    ACCELERATOR("Accelerator");

    private String title;

    private WindowEvent(String title) {
        this.title = title;
    }

    /**
     * @return the title.
     */
    @Override
    public String toString() {
        return title;
    }

}
