/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.core.view.tree;

import java.text.Collator;
import java.util.Comparator;

import no.g9.client.core.controller.DialogObjectConstant;
import no.g9.client.core.view.tree.TreeModel.Grouping;

/**
 * Comparator used to compare to TreeNodes
 *
 */
public class TreeNodeComparator implements Comparator<TreeNode> {

	private Grouping grouping = Grouping.GROUPED;

	private Collator collator =  Collator.getInstance();
	
	/**
	 * Create a new comparator using <code>grouping</code> during comparison.
	 * @param grouping .
	 */
	public TreeNodeComparator(Grouping grouping) {
		this.grouping = grouping;
		collator.setStrength(Collator.IDENTICAL);
	}

	@Override
	public int compare(TreeNode node1, TreeNode node2) {

        int retval = 0;
        
        if(node1 == null) {
        	retval = (node2 == null) ? 0 : -1;
        } else if (node2 == null) {
        	retval = 1;
        } else if (grouping != Grouping.NONE) {

        	// concatenate all available fields when comparing
        	String value1 = "";
        	for(DialogObjectConstant field : node1.getListRow().getFields()) {
        		value1 += node1.getListRow().getValue(field);
        	}

        	String value2 = "";
        	for(DialogObjectConstant field : node2.getListRow().getFields()) {
        		value2 += node2.getListRow().getValue(field);
        	}

            retval = collator.compare(value1.toString(), value2.toString());
           
        	if(grouping == Grouping.GROUPED) { // group by node type.
        		DialogObjectConstant const1 = node1.getNodeConst();
        		DialogObjectConstant const2 = node2.getNodeConst();
        		int grpval = const1.toString().compareTo(const2.toString());
        		if(grpval != 0) { // If node type is equal, then use result from field comparison
        			retval = grpval;
        		}

        	} else {
        		retval = retval * grouping.value;
        	}
        }

        return retval;

    }

}
