/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.client.spreadsheet;

/**
 * The class holds an element that is (or is not) to be exported.
 *
 */
public class ExportElement {

	/** The row in the local coordinate system. */
	private int row;

	/** The column in the local coordinate system. */
	private int column;

	/** Indicates if the element is shown. */
	private boolean shown;

	/** Indicates if the element is exported. */
	private boolean exported;

	/**
	 * Constructor that sets the attributes.
	 *
	 * @param row The row
	 * @param column The column
	 * @param shown Indicates that element is initially shown
	 * @param exported Indicates that element is exported
	 */
	public ExportElement(int row, int column, boolean shown, boolean exported) {
		this.row = row;
		this.column = column;
		this.shown = shown;
		this.exported = exported;
	}

	/**
	 * @return the row
	 */
	public int getRow() {
		return row;
	}

	/**
	 * @param row the row to set
	 */
	public void setRow(int row) {
		this.row = row;
	}

	/**
	 * @return the column
	 */
	public int getColumn() {
		return column;
	}

	/**
	 * @param column the column to set
	 */
	public void setColumn(int column) {
		this.column = column;
	}

	/**
	 * @return the hidden
	 */
	public boolean isShown() {
		return shown;
	}

	/**
	 * @param shown the hidden to set
	 */
	public void setShown(boolean shown) {
		this.shown = shown;
	}

	/**
	 * @return the exported
	 */
	public boolean isExported() {
		return exported;
	}

	/**
	 * @param exported the exported to set
	 */
	public void setExported(boolean exported) {
		this.exported = exported;
	}

}
