/*
 * Decompiled with CFR 0.152.
 */
package no.esito.jvine.communication;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import no.esito.jvine.controller.StateController;
import no.g9.client.core.controller.DialogCallBackValue;
import no.g9.exception.G9BaseException;
import no.g9.message.MessageSystem;

public class ExternalDialogCallBackValue {
    private String sourceName;
    private Object value;
    private String messageId;
    private Object[] messageArgs;
    private Integer opCode;
    private DialogCallBackValue.Flag flagValue;

    public ExternalDialogCallBackValue() {
    }

    public ExternalDialogCallBackValue(DialogCallBackValue dialogCallBackValue) {
        if (dialogCallBackValue.getSource() != null) {
            this.sourceName = ((StateController)dialogCallBackValue.getSource()).getDialogConstant().getInternalName();
        }
        if (dialogCallBackValue.getValue() != null) {
            this.value = dialogCallBackValue.getValue();
        }
        if (dialogCallBackValue.getMessage() != null) {
            this.setMessageId(dialogCallBackValue.getMessage().getMessageID());
            this.setMessageArgs(dialogCallBackValue.getMessage().getArgs());
        }
        this.opCode = dialogCallBackValue.getOpCode();
        this.flagValue = dialogCallBackValue.getFlagValue();
    }

    public DialogCallBackValue asDialogCallBackValue() {
        DialogCallBackValue dialogCallBackValue = new DialogCallBackValue(null, this.value, this.opCode);
        dialogCallBackValue.setFlagValue(this.flagValue);
        if (this.messageId != null) {
            dialogCallBackValue.setMessage(MessageSystem.getMessageFactory().getMessage(this.messageId, this.messageArgs));
        }
        return dialogCallBackValue;
    }

    public static String toJson(ExternalDialogCallBackValue externalDialogCallBackValue) {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, (Object)externalDialogCallBackValue);
            return writer.getBuffer().toString();
        }
        catch (JsonGenerationException e) {
            throw new G9BaseException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new G9BaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new G9BaseException((Throwable)e);
        }
    }

    public static ExternalDialogCallBackValue fromJson(String jsonRepresentation) {
        if (jsonRepresentation == null) {
            throw new IllegalArgumentException("The JSON representation can not be null");
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            ExternalDialogCallBackValue cbValue = (ExternalDialogCallBackValue)mapper.readValue(jsonRepresentation, ExternalDialogCallBackValue.class);
            return cbValue;
        }
        catch (JsonParseException e) {
            throw new G9BaseException((Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new G9BaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new G9BaseException((Throwable)e);
        }
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Object[] getMessageArgs() {
        return (Object[])this.messageArgs.clone();
    }

    public void setMessageArgs(Object[] messageArgs) {
        this.messageArgs = (Object[])messageArgs.clone();
    }

    public Integer getOpCode() {
        return this.opCode;
    }

    public void setOpCode(Integer opCode) {
        this.opCode = opCode;
    }

    public DialogCallBackValue.Flag getFlagValue() {
        return this.flagValue;
    }

    public void setFlagValue(DialogCallBackValue.Flag flagValue) {
        this.flagValue = flagValue;
    }
}

